% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rliger.R
\name{runWilcoxon}
\alias{runWilcoxon}
\title{Perform Wilcoxon rank-sum test}
\usage{
runWilcoxon(
  object,
  data.use = "all",
  compare.method = c("clusters", "datasets")
)
}
\arguments{
\item{object}{\code{liger} object.}

\item{data.use}{This selects which dataset(s) to use. (default 'all')}

\item{compare.method}{This indicates the metric of the test. Either 'clusters' or 'datasets'.}
}
\value{
A 10-columns data.frame with test results.
}
\description{
Perform Wilcoxon rank-sum tests on specified dataset using given method.
}
\examples{
ligerex <- createLiger(list(ctrl = ctrl, stim = stim))
ligerex <- normalize(ligerex)
ligerex <- selectGenes(ligerex)
ligerex <- scaleNotCenter(ligerex)
ligerex <- optimizeALS(ligerex, k = 5, max.iters = 1)
ligerex <- quantile_norm(ligerex)
ligerex <- louvainCluster(ligerex, resolution = 0.3)
wilcox.results <- runWilcoxon(ligerex, compare.method = "clusters")
wilcox.results <- runWilcoxon(ligerex, compare.method = "datasets", data.use = c(1, 2))
if (length(ligerex@h5file.info) > 0) {
    # For HDF5 based object
    # Need to sample cells and read into memory before running Wilcoxon test
    ligerex <- readSubset(ligerex, slot.use = "norm.data", max.cells = 1000)
    wilcox.results <- runWilcoxon(ligerex, compare.method = "clusters")
}
}
