% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mz-tile-coordinates.R
\name{mz_tile_coordinates}
\alias{mz_tile_coordinates}
\alias{as.mz_tile_coordinates}
\alias{as.mz_tile_coordinates.mz_tile_coordinates}
\alias{as.mz_tile_coordinates.mz_bbox}
\alias{as.mz_tile_coordinates.mz_location}
\alias{as.mz_tile_coordinates.mz_geocode_result}
\title{Specify tile coordinates}
\usage{
mz_tile_coordinates(x, y, z)

as.mz_tile_coordinates(obj, ...)

\method{as.mz_tile_coordinates}{mz_tile_coordinates}(obj, ...)

\method{as.mz_tile_coordinates}{mz_bbox}(obj, ..., z = NULL,
  height = NULL, width = NULL)

\method{as.mz_tile_coordinates}{mz_location}(obj, ..., z = 15L)

\method{as.mz_tile_coordinates}{mz_geocode_result}(obj, ..., z = 15L)
}
\arguments{
\item{x}{integer vector of x-coordinates}

\item{y}{integer vector of y-coordinates}

\item{z}{integer between 0 and 19 specifying the zoom level}

\item{obj}{An object that can be converted to tile coordinates}

\item{...}{Other arguments passed on to methods}

\item{height}{Height in pixels}

\item{width}{Width in pixels}
}
\description{
\code{\link{mz_vector_tiles}} requires tile coordinates or some other
specification of the region that is to be drawn. \code{\link{mz_vector_tiles}}
will automatically convert its inputs to vector tiles, so you generally won't
need to use this function directly.
}
\examples{
mz_tile_coordinates(19293, 24641, 16)

## can specify multiple contiguous tiles:
mz_tile_coordinates(19293:19294, 24641:24642, 16)

## a rectangular bounding box can be converted to tile coordinates:
as.mz_tile_coordinates(mz_rect(min_lon = -122.2856,
                               min_lat = 37.73742,
                               max_lon = -122.1749,
                               max_lat = 37.84632))

## zoom level is calculated based on desired pixel dimensions of the map:
as.mz_tile_coordinates(mz_rect(min_lon = -122.2856,
                               min_lat = 37.73742,
                               max_lon = -122.1749,
                               max_lat = 37.84632), height = 750, width = 1000)

## a bounding box can also be calculated:
as.mz_tile_coordinates(mz_bbox(oakland_public))

}
\seealso{
\code{\link{mz_vector_tiles}}, \code{\link{mz_bbox}}
}
