% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/html_resources.R
\name{find_external_resources}
\alias{find_external_resources}
\title{Find External Resource References}
\usage{
find_external_resources(input_file, encoding = getOption("encoding"))
}
\arguments{
\item{input_file}{path to the R Markdown document or HTML file to process}

\item{encoding}{the encoding of the document}
}
\value{
A data frame with the following columns:
  \describe{
   \item{path}{The relative path from the document to the resource}
   \item{explicit}{Whether the resource was specified explicitly
     (\code{TRUE}) or discovered implicitly (\code{FALSE})}
   \item{web}{Whether the resource is needed to display a Web page rendered
     from the document}
  }
}
\description{
Given an R Markdown document or HTML file, attempt to determine the set of
additional files needed in order to render and display the document.
}
\details{
This routine applies heuristics in order to scan a document for
  possible resource references.

  In R Markdown documents, it looks for references to files implicitly
  referenced in Markdown (e.g. \code{![alt](img.png)}), in the document's
  YAML header, in raw HTML chunks, and as quoted strings in R code chunks
  (e.g. \code{read.csv("data.csv")}).

  Resources specified explicitly in the YAML header for R Markdown documents
  are also returned. To specify resources in YAML, use the
  \code{resource_files} key:

  \preformatted{---
title: My Document
author: My Name
resource_files:
 - data/mydata.csv
 - images/figure.png
---}

  Each item in the \code{resource_files} list can refer to:
  \enumerate{
  \item A single file, such as \code{images/figure.png}, or
  \item A directory, such as \code{resources/data}, in which case all of the
    directory's content will be recursively included, or
  \item A wildcard pattern, such as \code{data/*.csv}, in which case all of
    the files matching the pattern will be included. No recursion is done in
    this case.
  }

  In HTML files (and raw HTML chunks in R Markdown documents), this routine
  searches for resources specified in common tag attributes, such as
  \code{<img src="...">}, \code{<link href="...">}, etc.

  In all cases, only resources that exist on disk and are contained in the
  document's directory (or a child thereof) are returned.
}

