% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odt_document.R
\name{odt_document}
\alias{odt_document}
\title{Convert to an OpenDocument Text (ODT) document}
\usage{
odt_document(fig_width = 5, fig_height = 4, fig_caption = FALSE,
  template = "default", reference_odt = "default", includes = NULL,
  keep_md = FALSE, md_extensions = NULL, pandoc_args = NULL)
}
\arguments{
\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default width (in inches) for figures}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{template}{Pandoc template to use for rendering. Pass "default" to use
the rmarkdown package default template; pass \code{NULL} to use pandoc's
built-in template; pass a path to use a custom template that you've
created.  See the documentation on
\href{http://pandoc.org/README.html}{pandoc online documentation}
for details on creating custom templates.}

\item{reference_odt}{Use the specified file as a style reference in
producing an odt file. For best results, the reference odt should be a
modified version of an odt file produced using pandoc. Pass "default"
to use the rmarkdown default styles.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to an ODT document.
}
\details{
See the \href{http://rmarkdown.rstudio.com/odt_document_format.html}{online
documentation} for additional details on using the \code{odt_document} format.

R Markdown documents can have optional metadata that is used to generate a
document header that includes the title, author, and date. For more details
see the documentation on R Markdown \link[=rmd_metadata]{metadata}.

R Markdown documents also support citations. You can find more information on
the markdown syntax for citations in the
\href{http://rmarkdown.rstudio.com/authoring_bibliographies_and_citations.html}{Bibliographies
and Citations} article in the online documentation.
}
\examples{
\dontrun{

library(rmarkdown)

# simple invocation
render("input.Rmd", odt_document())

# specify an option for syntax highlighting
render("input.Rmd", odt_document(highlight = "zenburn"))
}

}

