% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tufte_handout.R
\name{tufte_handout}
\alias{tufte_handout}
\title{Tufte handout format (PDF)}
\usage{
tufte_handout(fig_width = 4, fig_height = 2.5, fig_crop = TRUE,
  dev = "pdf", highlight = "default", keep_tex = FALSE,
  citation_package = c("natbib", "biblatex"), includes = NULL,
  md_extensions = NULL, pandoc_args = NULL)
}
\arguments{
\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default width (in inches) for figures}

\item{fig_crop}{\code{TRUE} to automatically apply the \code{pdfcrop} utility
(if available) to pdf figures}

\item{dev}{Graphics device to use for figure output (defaults to pdf)}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso",
"zenburn", and "haddock". Pass \code{NULL} to prevent syntax highlighting.}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF}

\item{citation_package}{The LaTeX package to process citations, \code{natbib}
or \code{biblatex}.}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}}
for additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\description{
Template for creating a handout according to the style of 
Edward R. Tufte and Richard Feynman.
}

