% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_document.R
\name{html_document}
\alias{html_document}
\title{Convert to an HTML document}
\usage{
html_document(
  toc = FALSE,
  toc_depth = 3,
  toc_float = FALSE,
  number_sections = FALSE,
  section_divs = TRUE,
  fig_width = 7,
  fig_height = 5,
  fig_retina = 2,
  fig_caption = TRUE,
  dev = "png",
  df_print = "default",
  code_folding = c("none", "show", "hide"),
  code_download = FALSE,
  self_contained = TRUE,
  theme = "default",
  highlight = "default",
  mathjax = "default",
  template = "default",
  extra_dependencies = NULL,
  css = NULL,
  includes = NULL,
  keep_md = FALSE,
  lib_dir = NULL,
  md_extensions = NULL,
  pandoc_args = NULL,
  ...
)
}
\arguments{
\item{toc}{\code{TRUE} to include a table of contents in the output}

\item{toc_depth}{Depth of headers to include in table of contents}

\item{toc_float}{\code{TRUE} to float the table of contents to the left of the
main document content. Rather than \code{TRUE} you may also pass a list of
options that control the behavior of the floating table of contents. See the
\emph{Floating Table of Contents} section below for details.}

\item{number_sections}{\code{TRUE} to number section headings}

\item{section_divs}{Wrap sections in <div> tags, and attach identifiers to the
enclosing <div> rather than the header itself.}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default height (in inches) for figures}

\item{fig_retina}{Scaling to perform for retina displays (defaults to 2, which
currently works for all widely used retina displays). Set to \code{NULL} to
prevent retina scaling. Note that this will always be \code{NULL} when
\code{keep_md} is specified (this is because \code{fig_retina} relies on
outputting HTML directly into the markdown document).}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{dev}{Graphics device to use for figure output (defaults to png)}

\item{df_print}{Method to be used for printing data frames. Valid values
include "default", "kable", "tibble", and "paged". The "default" method
uses a corresponding S3 method of \code{print}, typically
\code{print.data.frame}. The "kable" method uses the
\code{\link[knitr:kable]{knitr::kable}} function. The "tibble" method uses
the \pkg{tibble} package to print a summary of the data frame. The "paged"
method creates a paginated HTML table (note that this method is only valid
for formats that produce HTML). In addition to the named methods you can
also pass an arbitrary function to be used for printing data frames. You
can disable the \code{df_print} behavior entirely by setting the option
\code{rmarkdown.df_print} to \code{FALSE}.}

\item{code_folding}{Enable document readers to toggle the display of R code
chunks. Specify \code{"none"} to display all code chunks (assuming
they were knit with \code{echo = TRUE}). Specify \code{"hide"} to hide all R
code chunks by default (users can show hidden code chunks either
individually or document-wide). Specify \code{"show"} to show all R code
chunks by default.}

\item{code_download}{Embed the Rmd source code within the document and provide
a link that can be used by readers to download the code.}

\item{self_contained}{Produce a standalone HTML file with no external
dependencies, using data: URIs to incorporate the contents of linked
scripts, stylesheets, images, and videos. Note that even for self contained
documents MathJax is still loaded externally (this is necessary because of
its size).}

\item{theme}{Visual theme ("default", "cerulean", "journal", "flatly",
"darkly", "readable", "spacelab", "united", "cosmo", "lumen", "paper",
"sandstone", "simplex", or "yeti"). Pass \code{NULL} for no theme (in this
case you can use the \code{css} parameter to add your own styles).}

\item{highlight}{Syntax highlighting style. Supported styles include
"default", "tango", "pygments", "kate", "monochrome", "espresso", "zenburn",
"haddock", and "textmate". Pass \code{NULL} to prevent syntax highlighting.}

\item{mathjax}{Include mathjax. The "default" option uses an https URL from a
MathJax CDN. The "local" option uses a local version of MathJax (which is
copied into the output directory). You can pass an alternate URL or pass
\code{NULL} to exclude MathJax entirely.}

\item{template}{Pandoc template to use for rendering. Pass "default" to use
the rmarkdown package default template; pass \code{NULL} to use pandoc's
built-in template; pass a path to use a custom template that you've created.
Note that if you don't use the "default" template then some features of
\code{html_document} won't be available (see the Templates section below for
more details).}

\item{extra_dependencies, ...}{Additional function arguments to pass to the
base R Markdown HTML output formatter \code{\link{html_document_base}}}

\item{css}{One or more css files to include}

\item{includes}{Named list of additional content to include within the
document (typically created using the \code{\link{includes}} function).}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{lib_dir}{Directory to copy dependent HTML libraries (e.g. jquery,
bootstrap, etc.) into. By default this will be the name of the document with
\code{_files} appended to it.}

\item{md_extensions}{Markdown extensions to be added or removed from the
default definition or R Markdown. See the \code{\link{rmarkdown_format}} for
additional details.}

\item{pandoc_args}{Additional command line options to pass to pandoc}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
Format for converting from R Markdown to an HTML document.
}
\details{
See the \href{https://rmarkdown.rstudio.com/html_document_format.html}{online
documentation} for additional details on using the \code{html_document}
format.

R Markdown documents can have optional metadata that is used to generate a
document header that includes the title, author, and date. For more details
see the documentation on R Markdown \link[=rmd_metadata]{metadata}.

R Markdown documents also support citations. You can find more information on
the markdown syntax for citations in the
\href{https://rmarkdown.rstudio.com/authoring_bibliographies_and_citations.html}{Bibliographies
and Citations} article in the online documentation.
}
\section{Navigation Bars}{


 If you have a set of html documents which you'd like to provide a common
 global navigation bar for, you can include a "_navbar.yml" or "_navbar.html"
 file within the same directory as your html document and it will automatically
 be included at the top of the document.

 The "_navbar.yml" file includes \code{title}, \code{type}, \code{left}, and
 \code{right} fields (to define menu items for the left and right of the navbar
 respectively). Menu items include \code{title} and \code{href} fields. For example:

 \preformatted{title: "My Website"
type: default
left:
  - text: "Home"
    href: index.html
  - text: "Other"
    href: other.html
right:
  - text: GitHub
    href: https://github.com}
 The \code{type} field is optional and can take the value "default" or "inverse" (which
 provides a different color scheme for the navigation bar).

 Alternatively, you can include a "_navbar.html" file which is a full HTML definition
 of a bootstrap navigation bar. For a simple example of including a navigation bar see
 \url{https://github.com/rstudio/rmarkdown-website/blob/master/_navbar.html}.
  For additional documentation on creating Bootstrap navigation bars see
 \url{http://getbootstrap.com/components/#navbar}.
}

\section{Floating Table of Contents}{


 You may specify a list of options for the \code{toc_float} parameter which
 control the behavior of the floating table of contents. Options include:

 \itemize{ \item{\code{collapsed} (defaults to \code{TRUE}) controls whether
 the table of contents appears with only the top-level (H2) headers. When
 collapsed the table of contents is automatically expanded inline when
 necessary.} \item{\code{smooth_scroll} (defaults to \code{TRUE}) controls
 whether page scrolls are animated when table of contents items are navigated
 to via mouse clicks.} \item{\code{print} (defaults to \code{TRUE}) controls
 whether the table of contents appears when user prints out the HTML page.}}
}

\section{Tabbed Sections}{


 You can organize content using tabs by applying the \code{.tabset} class
 attribute to headers within a document. This will cause all sub-headers of
 the header with the \code{.tabset} attribute to appear within tabs rather
 than as standalone sections. For example:

 \preformatted{## Quarterly Results {.tabset}

### By Product

### By Region }

 You can also specify two additional attributes to control the appearance and
 behavior of the tabs. The \code{.tabset-fade} attributes causes the tabs to
 fade in and out when switching. The \code{.tabset-pills} attribute causes
 the visual appearance of the tabs to be "pill" rather than traditional tabs.
 For example:

 \preformatted{## Quarterly Results {.tabset .tabset-fade .tabset-pills}}
}

\section{Templates}{


 You can provide a custom HTML template to be used for rendering. The syntax
 for templates is described in the
 \href{http://pandoc.org/README.html}{pandoc documentation}. You can also use
 the basic pandoc template by passing \code{template = NULL}.

 Note however that if you choose not to use the "default" HTML template then
 several aspects of HTML document rendering will behave differently:

 \itemize{ \item{The \code{theme} parameter does not work (you can still
 provide styles using the \code{css} parameter). } \item{For the
 \code{highlight} parameter, the default highlighting style will resolve to
 "pygments" and the "textmate" highlighting style is not available }
 \item{The \code{toc_float} parameter will not work. } \item{The
 \code{code_folding} parameter will not work. } \item{Tabbed sections (as
 described above) will not work.} \item{Navigation bars (as described above)
 will not work. }\item{MathJax will not work if \code{self_contained} is
 \code{TRUE} (these two options can't be used together in normal pandoc
 templates). } }

 Due to the above restrictions, you might consider using the \code{includes}
 parameter as an alternative to providing a fully custom template.
}

\examples{
\dontrun{
library(rmarkdown)

render("input.Rmd", html_document())

render("input.Rmd", html_document(toc = TRUE))
}
}
