/*
 * Decompiled with CFR 0.152.
 */
package dmLab.geneticFramework;

import dmLab.geneticFramework.Evaluator;
import dmLab.geneticFramework.Instance;
import java.util.Random;

public final class Population {
    private float[] evals;
    private float[] roulette;
    private Instance[] instances;
    private Random rand = new Random(System.currentTimeMillis());

    /*
     * WARNING - void declaration
     */
    public Population(int instancesNumber, Instance instance) {
        void var2_2;
        void var1_1;
        this.init((int)var1_1, (Instance)var2_2);
    }

    private void init(int instancesNumber, Instance instance) {
        this.instances = new Instance[instancesNumber];
        this.evals = new float[instancesNumber];
        this.roulette = new float[instancesNumber];
        int i = 0;
        while (i < this.instances.length) {
            this.instances[i] = instance.clone();
            this.instances[i].init();
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Population(Population oldPopulation, int mutationType) {
        Population population = oldPopulation;
        this.instances = new Instance[population.instances.length];
        population = oldPopulation;
        this.evals = new float[population.instances.length];
        population = oldPopulation;
        this.roulette = new float[population.instances.length];
        oldPopulation.prepareRoulette();
        int i = 0;
        while (i < this.instances.length) {
            void var3_4;
            int mother;
            int father = mother = oldPopulation.getParent();
            int shots = 0;
            while (father == mother && shots < this.instances.length) {
                father = oldPopulation.getParent();
                ++shots;
            }
            this.instances[i] = new Instance(oldPopulation.getInstance((int)var3_4), oldPopulation.getInstance(father));
            this.instances[i].mutate(mutationType);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Instance getInstance(int index) {
        void var1_1;
        if (index >= this.instances.length) {
            return null;
        }
        return this.instances[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final float getEval(int index) {
        void var1_1;
        return this.evals[var1_1];
    }

    private boolean prepareRoulette() {
        double d;
        Population population = this;
        float f = Float.MAX_VALUE;
        int n = 0;
        int n2 = 0;
        while (n2 < population.evals.length) {
            if (f > population.evals[n2]) {
                f = population.evals[n2];
                n = n2;
            }
            ++n2;
        }
        double min = this.evals[n];
        min = d < 0.0 ? Math.sqrt(min * -1.0) : 0.0;
        population = this;
        f = Float.MAX_VALUE;
        n = 0;
        while (n < population.evals.length) {
            if (f > population.evals[n] && population.evals[n] > 0.0f) {
                f = population.evals[n];
            }
            ++n;
        }
        float minPositiveEval = f;
        int i = 0;
        while (i < this.evals.length) {
            this.roulette[i] = this.evals[i] < 0.0f ? (float)Math.sqrt(-1.0 * (double)this.evals[i]) + (float)min : this.evals[i] + (float)min;
            if (this.roulette[i] == 0.0f) {
                int n3 = i;
                this.roulette[n3] = this.roulette[n3] + minPositiveEval * 0.1f;
            }
            if (i != 0) {
                int n4 = i;
                this.roulette[n4] = this.roulette[n4] + this.roulette[i - 1];
            }
            ++i;
        }
        return true;
    }

    private int getParent() {
        double value = this.rand.nextDouble() * (double)this.roulette[this.roulette.length - 1];
        int i = 0;
        while (i < this.roulette.length) {
            if (value < (double)this.roulette[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final void evaluate(Evaluator evaluator) {
        int i = 0;
        while (i < this.instances.length) {
            this.evals[i] = evaluator.eval(this.instances[i]);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getMaxEvalId() {
        void var2_2;
        float maxEval = this.evals[0];
        int maxId = 0;
        int i = 0;
        while (i < this.evals.length) {
            if (this.evals[i] > maxEval) {
                maxEval = this.evals[i];
                maxId = i;
            }
            ++i;
        }
        return (int)var2_2;
    }
}

