/*
 * Decompiled with CFR 0.152.
 */
package dmLab.mcfs.mcfsEngine;

import dmLab.array.FArray;
import dmLab.array.functions.DiscFunctions;
import dmLab.classifier.Classifier;
import dmLab.experiment.classification.ClassificationBody;
import dmLab.experiment.classification.ClassificationParams;
import dmLab.mcfs.MCFSParams;
import dmLab.mcfs.attributesRI.AttributesRI;
import dmLab.mcfs.attributesRI.Ranking;
import dmLab.mcfs.mcfsEngine.MCFSFinalCV;
import dmLab.mcfs.mcfsEngine.framework.MCFSClassic;
import dmLab.mcfs.mcfsEngine.framework.MCFSFramework;
import dmLab.mcfs.mcfsEngine.framework.MCFSPermutation;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import dmLab.utils.dataframe.DataFrame;
import dmLab.utils.helpers.MinMax;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.zip.ZipOutputStream;
import jdistlib.disttest.DistributionTest;
import jdistlib.disttest.TestKind;

public final class MCFSExperiment
implements Runnable {
    private MCFSFramework mcfs;
    private MCFSParams myParams;
    private Random random;
    private int topRankingSize = 0;

    /*
     * WARNING - void declaration
     */
    public MCFSExperiment(MCFSParams mcfsParams) {
        void var1_1;
        if (mcfsParams.verbose) {
            System.out.println("MCFSExperiment Params: \n" + mcfsParams.toString());
        }
        this.random = new Random(mcfsParams.seed);
        this.myParams = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void run() {
        File tmpdir;
        if (this.myParams.mode == 2) {
            void var3_3;
            MCFSParams mcfsParamsP1 = this.myParams.clone();
            this.myParams.clone().buildID = false;
            mcfsParamsP1.finalRuleset = false;
            mcfsParamsP1.finalCV = false;
            mcfsParamsP1.saveResultFiles = false;
            mcfsParamsP1.zipResult = false;
            mcfsParamsP1.minTopRankingSize = 0.05f;
            mcfsParamsP1.cutoffMethod = "contrast";
            mcfsParamsP1.filesufix_RI = MCFSParams.FILESUFIX_RI_PHASE_1;
            System.out.println("****************************************************");
            System.out.println("*** Running Phase I - Initial MCFS-ID filtering  ***");
            FArray tmpArray = this.start(mcfsParamsP1);
            if (tmpArray == null) {
                return;
            }
            AttributesRI ri_phase1 = this.mcfs.globalStats.getAttrImportances()[0];
            File file = new File(String.valueOf(mcfsParamsP1.resFilesPATH) + File.separator + mcfsParamsP1.getExperimentName() + "_" + ri_phase1.label + "_" + mcfsParamsP1.filesufix_RI);
            DiscFunctions.saveString(file.getAbsolutePath(), ri_phase1.toString());
            Object input_phase2_file = new File(String.valueOf(mcfsParamsP1.tmpPATH) + File.separator + DiscFunctions.dropFileExtension(new File(mcfsParamsP1.inputFileName)) + ".adx");
            DiscFunctions.saveString(((File)input_phase2_file).getAbsolutePath(), tmpArray.toString());
            MCFSParams mcfsParamsP2 = this.myParams.clone();
            this.myParams.clone().inputFilesPATH = ((File)input_phase2_file).getAbsoluteFile().getParent();
            mcfsParamsP2.inputFileName = ((File)input_phase2_file).getName();
            mcfsParamsP2.minTopRankingSize = 0.0f;
            mcfsParamsP2.filesufix_RI = MCFSParams.FILESUFIX_RI_PHASE_2;
            mcfsParamsP2.zipResult = false;
            System.out.println("***************************************************");
            System.out.println("*** Running Phase II - Final MCFS-ID filtering  ***");
            this.start(mcfsParamsP2);
            input_phase2_file = this;
            Object ri_phase2 = ((MCFSExperiment)input_phase2_file).mcfs.globalStats.getAttrImportances()[0];
            DataFrame df_ri_phase1 = ri_phase1.toDataFrame(AttributesRI.getMeasuresNamesBasic());
            DataFrame df_ri_phase2 = ((AttributesRI)ri_phase2).toDataFrame(AttributesRI.getMeasuresNamesBasic());
            DataFrame ri_final = MCFSExperiment.combineRankings(df_ri_phase1, df_ri_phase2);
            ri_phase2 = new File(String.valueOf(mcfsParamsP2.resFilesPATH) + File.separator + mcfsParamsP2.getExperimentName() + "_" + ((AttributesRI)ri_phase2).label + "_" + MCFSParams.FILESUFIX_RI);
            DiscFunctions.saveString(((File)ri_phase2).getAbsolutePath(), var3_3.toString());
            if (this.myParams.zipResult) {
                void var2_2;
                MCFSExperiment.zipResult((MCFSParams)var2_2);
            }
        } else {
            MCFSExperiment mCFSExperiment = this;
            mCFSExperiment.start(mCFSExperiment.myParams);
        }
        if ((tmpdir = new File(this.myParams.tmpPATH)).exists()) {
            void var1_1;
            DiscFunctions.deleteDir((File)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private FArray start(MCFSParams mcfsParams) {
        void var2_2;
        Object cutoffValues;
        if (mcfsParams.verbose) {
            System.out.println("MCFSExperiment.start() Params: \n" + mcfsParams.toString());
        }
        long start = System.currentTimeMillis();
        if (!mcfsParams.check(null)) {
            return null;
        }
        DataFrame permutationRIValues = null;
        ArrayList<Float> maxPermutationRI = new ArrayList<Float>();
        ArrayList<Float> maxPermutationID = new ArrayList<Float>();
        ArrayList<String> permFiles = new ArrayList<String>();
        if (mcfsParams.cutoffMethod.equalsIgnoreCase("permutations")) {
            MCFSParams cutoffParams = mcfsParams.clone();
            int i = 0;
            while (i < cutoffParams.cutoffPermutations) {
                System.out.println("***************************************************");
                System.out.println("*** MCFS-ID Cutoff Permutation Experiment #" + (i + 1) + "/" + cutoffParams.cutoffPermutations + " ***");
                System.out.println("***************************************************");
                this.mcfs = new MCFSPermutation(this.random);
                this.mcfs.chartTitle = "MCFS-ID Progress - Permutation Experiment #" + (i + 1);
                this.mcfs.experimentName = "perm_" + (i + 1) + "_" + cutoffParams.getExperimentName();
                permFiles.add(new File(String.valueOf(mcfsParams.resFilesPATH) + File.separator + this.mcfs.experimentName + "__" + mcfsParams.filesufix_RI).getAbsolutePath());
                cutoffParams.saveResultFiles = false;
                cutoffParams.zipResult = false;
                if (!this.mcfs.run(cutoffParams)) {
                    return null;
                }
                AttributesRI cutoff_RI = this.mcfs.globalStats.getAttrImportances()[0];
                if (permutationRIValues == null) {
                    permutationRIValues = MCFSExperiment.createPermutationResult(this.mcfs.mcfsArrays.sourceArray, cutoffParams);
                }
                AttributesRI attributesRI = cutoff_RI;
                permutationRIValues.setColumn(i + 1, attributesRI.getImportanceValues(attributesRI.mainMeasureIdx));
                AttributesRI attributesRI2 = cutoff_RI;
                float[] minMax = attributesRI2.getMinMaxImportances(attributesRI2.mainMeasureIdx);
                maxPermutationRI.add(Float.valueOf(minMax[1]));
                if (this.mcfs.globalStats.getAttrConnections() != null) {
                    maxPermutationID.add(Float.valueOf(this.mcfs.globalStats.getAttrConnections().getMaxID()));
                }
                System.out.println("");
                ++i;
            }
        }
        System.out.println("**************************");
        System.out.println("*** MCFS-ID Experiment ***");
        System.out.println("**************************");
        this.mcfs = new MCFSClassic(this.random);
        this.mcfs.chartTitle = "MCFS-ID Progress - Real Data";
        if (!this.mcfs.run(mcfsParams)) {
            return null;
        }
        String experimentName = this.mcfs.experimentName;
        AttributesRI importancesClassic = this.mcfs.globalStats.getAttrImportances()[0];
        if (permutationRIValues != null) {
            int mainMeasureIndex = importancesClassic.mainMeasureIdx;
            DataFrame p_values = MCFSExperiment.calc_pValues$662b6a5a(permutationRIValues, importancesClassic.getImportanceValues(mainMeasureIndex));
            permutationRIValues.cbind(p_values);
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_PERMUTATIONS, permutationRIValues.toString());
            System.out.println("*** Calculation of cutoff RI (based on permutations) ***");
            float[] minMaxRI = importancesClassic.getMinMaxImportances(mainMeasureIndex);
            System.out.println("Max RI (raw data) = " + minMaxRI[1]);
            System.out.println("Max RI (after permutations) = " + Arrays.toString(maxPermutationRI.toArray()));
            double cutoffRI = MCFSExperiment.getCutoff(mcfsParams.cutoffAlpha, ArrayUtils.Float2double(maxPermutationRI.toArray()));
            Ranking topRanking = importancesClassic.getTopRanking(mainMeasureIndex, (float)cutoffRI);
            this.topRankingSize = 0;
            if (topRanking != null) {
                this.topRankingSize = topRanking.size();
            }
            System.out.println("Cutoff RI (based on permutations) = " + DiscFunctions.formatFloat(cutoffRI, 7));
            System.out.println("Important attributes (based on permutations) = " + this.topRankingSize);
            double cutoffID = Double.NaN;
            if (!maxPermutationID.isEmpty()) {
                System.out.println("*** Calculation of cutoff ID ***");
                cutoffID = MCFSExperiment.getCutoff(mcfsParams.cutoffAlpha, ArrayUtils.Float2double(maxPermutationID.toArray()));
                System.out.println("Cutoff ID (based on permutations)  = " + DiscFunctions.formatFloat(cutoffID, 7));
            }
            Object cutoff = this.mcfs.globalStats.getCutoff().getCutoffTable();
            cutoff = ((DataFrame)cutoff).excludeRows(new int[]{((DataFrame)cutoff).rows() - 1});
            DataFrame cutoffRow = new DataFrame(1, (DataFrame)cutoff);
            int lastRowIdx = cutoffRow.rows() - 1;
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("method"), "permutations");
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("minRI"), cutoffRI);
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("size"), this.topRankingSize);
            cutoffRow.set(lastRowIdx, cutoffRow.getColIdx("minID"), cutoffID);
            ((DataFrame)cutoff).rbind(cutoffRow);
            this.mcfs.globalStats.getCutoff().setCutoffTable((DataFrame)cutoff);
            this.mcfs.globalStats.getCutoff().addMeanValue(importancesClassic);
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_CUTOFF, this.mcfs.globalStats.getCutoff().toString());
            if (mcfsParams.verbose) {
                Object[] s = new String[1];
                s = permFiles.toArray(s);
                System.out.println("deleting files: " + Arrays.toString(s));
            }
            DiscFunctions.deleteFiles(permFiles);
            String topRankingMethod = this.mcfs.globalStats.getCutoff().getMethod(mcfsParams.cutoffMethod);
            this.topRankingSize = (int)this.mcfs.globalStats.getCutoff().getCutoffValue(topRankingMethod);
            cutoff = importancesClassic.getTopRankingSize(mainMeasureIndex, this.topRankingSize);
            System.out.println("*** Final Important attributes (based on " + topRankingMethod + ") = " + ((Ranking)cutoff).size());
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_TOPRANKING, ((Ranking)cutoff).toString());
        }
        if (mcfsParams.finalCV) {
            int topRankingSize = Math.max((int)this.mcfs.globalStats.getCutoff().getCutoffValue(mcfsParams.cutoffMethod), 4);
            MCFSFinalCV simpleCV = this.mcfs.mcfsArrays.sourceArray.isTargetNominal() ? new MCFSFinalCV(new int[]{Classifier.J48, Classifier.RF, Classifier.NB, Classifier.SVM, Classifier.KNN, Classifier.LOGISTIC, Classifier.RIPPER}, this.random) : new MCFSFinalCV(new int[]{Classifier.M5}, this.random);
            cutoffValues = MCFSExperiment.getCutoffValues(new int[]{topRankingSize});
            System.out.println("");
            System.out.println("*** Running CV experiment on input data limited to the top " + Arrays.toString((int[])cutoffValues) + " attributes ***");
            DataFrame res = simpleCV.run(this.mcfs.mcfsArrays.sourceArray, this.mcfs.globalStats.getAttrImportances()[0], (int[])cutoffValues, mcfsParams.finalCVfolds, mcfsParams.finalCVSetSize, mcfsParams.finalCVRepetitions);
            if (mcfsParams.saveResultFiles) {
                DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_CV_RESULT, res.toString());
                int cmatrixIdx = ArrayUtils.indexOf((int[])cutoffValues, topRankingSize);
                if (cmatrixIdx != -1 && simpleCV.j48ConfMatrix[cmatrixIdx] != null) {
                    DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_MATRIX_TOP, simpleCV.j48ConfMatrix[cmatrixIdx].toString(false, true, false, ","));
                }
            }
        }
        int topRankingSize = Math.max((int)this.mcfs.globalStats.getCutoff().getCutoffValue(mcfsParams.cutoffMethod), 2);
        cutoffValues = this.mcfs.mcfsArrays.sourceArray;
        int sourceArrayColNumber = ((FArray)cutoffValues).attributes.length - 1;
        int minTopRankingValue = (int)((float)sourceArrayColNumber * mcfsParams.minTopRankingSize);
        if (topRankingSize < minTopRankingValue) {
            String s = "Warning! Number of top attributes from Phase I equals to " + topRankingSize + " (" + DiscFunctions.formatFloat(100.0 * (double)topRankingSize / (double)sourceArrayColNumber, 1) + "%). Phase II will use " + minTopRankingValue + " (" + DiscFunctions.formatFloat(100.0 * (double)mcfsParams.minTopRankingSize, 1) + "%) of top attributes.";
            System.err.println(s);
            topRankingSize = minTopRankingValue;
        }
        int[] topRankingColMask = DiscFunctions.getColumnsMask(this.mcfs.mcfsArrays.sourceArray, this.mcfs.globalStats.getAttrImportances()[0], topRankingSize);
        FArray topRankingArray = (FArray)DiscFunctions.selectColumns(this.mcfs.mcfsArrays.sourceArray, topRankingColMask);
        if (mcfsParams.finalRuleset && this.mcfs.mcfsArrays.sourceArray.isTargetNominal()) {
            System.out.println("");
            System.out.println("*** Building final RIPPER ruleset on top " + topRankingSize + " attributes ***");
            ClassificationBody classification = new ClassificationBody(this.random);
            classification.setParameters(new ClassificationParams());
            classification.classParams.verbose = false;
            classification.classParams.saveClassifier = false;
            classification.classParams.savePredictionResult = false;
            classification.classParams.repetitions = 1;
            classification.classParams.model = Classifier.RIPPER;
            classification.initClassifier();
            FArray fArray = topRankingArray;
            classification.runTrainTest(fArray, fArray);
            String ripperResult = String.valueOf(classification.classifier.toString(false)) + "\n";
            classification.initClassifier();
            classification.classParams.folds = mcfsParams.finalCVfolds;
            classification.classParams.repetitions = mcfsParams.finalCVRepetitions;
            classification.runCV(topRankingArray);
            ripperResult = String.valueOf(ripperResult) + "RIPPER CV Result (10 folds repeated " + mcfsParams.finalCVRepetitions + " times)\n" + classification.predResult.toString();
            System.out.println(classification.classifier.getPredResult().confusionMatrix.statsToString(2, false));
            if (mcfsParams.saveResultFiles) {
                DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_RULESET, ripperResult);
            }
        }
        if (mcfsParams.saveResultFiles & mcfsParams.savePrunedData) {
            System.out.println("*** Saving pruned data ***");
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_DATA + ".adh", topRankingArray.toADH());
            DiscFunctions.saveString(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + "_" + MCFSParams.FILESUFIX_DATA + ".csv", topRankingArray.toCSV());
        }
        if (mcfsParams.saveResultFiles && mcfsParams.zipResult) {
            void var1_1;
            MCFSExperiment.zipResult((MCFSParams)var1_1);
        }
        long l = System.currentTimeMillis();
        float experimentTime = (float)(l - var2_2) / 1000.0f;
        System.out.println("*** MCFS-ID Processing is done. Time: " + DiscFunctions.timeIntervalFormat(experimentTime) + " ***");
        System.out.println();
        return topRankingArray;
    }

    /*
     * WARNING - void declaration
     */
    private static DataFrame createPermutationResult(FArray inputArrray, MCFSParams mcfsParams) {
        void var3_4;
        FArray fArray;
        void var2_2;
        void var1_1;
        String[] colNames = new String[mcfsParams.cutoffPermutations + 1];
        short[] colTypes = new short[colNames.length];
        colNames[0] = "attribute";
        colTypes[0] = 0;
        int i22 = 1;
        while (i22 < colNames.length) {
            colNames[i22] = "perm_".concat(String.valueOf(i22));
            colTypes[i22] = 1;
            ++i22;
        }
        FArray i22 = inputArrray;
        DataFrame permResult = new DataFrame(i22.attributes.length - 1, colNames.length);
        permResult.setColNames((String[])var1_1);
        permResult.setColTypes((short[])var2_2);
        permResult.setColumn(0, fArray.getColNames(false));
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private static double getCutoff(double alpha, double[] values) {
        void var0_1;
        void var2_2;
        void var3_3;
        double pValue = DiscFunctions.andersonDarlingNormTest(values);
        System.out.println("Anderson-Darling normality test p-value = " + DiscFunctions.formatFloat((double)var3_3, 7));
        double[] confidence = DiscFunctions.getConfidenceInterval(alpha, (double[])var2_2);
        System.out.println("Confidence Interval: " + DiscFunctions.formatFloat(confidence[0], 7) + " ; " + DiscFunctions.formatFloat(confidence[1], 7));
        return (double)var0_1[1];
    }

    /*
     * WARNING - void declaration
     */
    private static int[] getCutoffValues(int[] cutoffValues) {
        int[] nArray;
        Integer[] integerArray;
        void var1_1;
        Arrays.sort(cutoffValues);
        HashSet<Integer> vset = new HashSet<Integer>();
        int i = 0;
        while (i <= 0) {
            vset.add(cutoffValues[0]);
            ++i;
        }
        vset.removeAll(Arrays.asList(0));
        Integer[] tmpArray = new Integer[1];
        tmpArray = vset.toArray(tmpArray);
        cutoffValues = ArrayUtils.Integer2int(tmpArray);
        Arrays.sort(cutoffValues);
        vset.add(Math.round((float)cutoffValues[0] * 0.75f));
        vset.add(Math.round((float)cutoffValues[0] * 0.5f));
        vset.add(Math.round((float)cutoffValues[0] * 0.25f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 1.25f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 1.5f));
        vset.add(Math.round((float)cutoffValues[cutoffValues.length - 1] * 2.0f));
        integerArray = (Integer[])var1_1.toArray(integerArray);
        cutoffValues = ArrayUtils.Integer2int(integerArray);
        Arrays.sort(cutoffValues);
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    private static DataFrame calc_pValues$662b6a5a(DataFrame permutationRIValues, float[] valuesRI) {
        void var2_2;
        void var1_1;
        DataFrame dataFrame;
        String[] colNames = permutationRIValues.getColNames();
        boolean[] colNamesMask = new boolean[colNames.length];
        int permNumber = 0;
        int i = 0;
        while (i < colNames.length) {
            if (colNames[i].startsWith("perm_")) {
                colNamesMask[i] = true;
                ++permNumber;
            } else {
                colNamesMask[i] = false;
            }
            ++i;
        }
        float[] mean = new float[permutationRIValues.rows()];
        float[] normality_p = new float[permutationRIValues.rows()];
        float[] ttest_p = new float[permutationRIValues.rows()];
        int i2 = 0;
        while (i2 < permutationRIValues.rows()) {
            Object[] row = permutationRIValues.getRow(i2);
            double[] permRI = new double[permNumber];
            int currPermIdx = 0;
            int j = 0;
            while (j < row.length) {
                if (colNamesMask[j]) {
                    permRI[currPermIdx++] = ((Float)row[j]).floatValue();
                }
                ++j;
            }
            mean[i2] = (float)MathUtils.mean(permRI);
            normality_p[i2] = (float)DiscFunctions.andersonDarlingNormTest(permRI);
            double d = valuesRI[i2];
            double[] dArray = permRI;
            dArray = DistributionTest.t_test((double[])permRI, (double)d, (TestKind)TestKind.TWO_SIDED);
            ttest_p[i2] = (float)dArray[1];
            ++i2;
        }
        DataFrame p_values = new DataFrame(dataFrame.rows(), 4);
        p_values.setColNames(new String[]{"mean", "RI_norm", "normality_test_p", "t_test_p"});
        p_values.setColTypes(new short[]{1, 1, 1, 1});
        p_values.setColumn(0, mean);
        p_values.setColumn(1, (float[])var1_1);
        p_values.setColumn(2, (float[])var2_2);
        p_values.setColumn(3, ttest_p);
        return p_values;
    }

    /*
     * WARNING - void declaration
     */
    private static DataFrame combineRankings(DataFrame df_ri_phase1, DataFrame df_ri_phase2) {
        int rows = df_ri_phase1.rows();
        boolean[] attrMask = new boolean[rows];
        int attrColIndex = df_ri_phase2.getColIdx(AttributesRI.ATTRIBUTE_LABEL);
        int attrRIIndx = df_ri_phase1.getColIdx("RI");
        df_ri_phase2.setKeyColumn(attrColIndex);
        int i = 0;
        while (i < rows) {
            String currAttr = df_ri_phase1.get(i, attrColIndex).toString();
            if (currAttr.startsWith(MCFSParams.CONTRAST_ATTR_NAME)) {
                attrMask[i] = false;
            } else {
                attrMask[i] = true;
                if (df_ri_phase2.getRowIdx(currAttr) >= 0) {
                    df_ri_phase1.set(i, attrRIIndx, Float.valueOf(-1.0f));
                }
            }
            ++i;
        }
        DataFrame df_ri_combined = df_ri_phase1.filterRows(attrMask);
        df_ri_phase1.filterRows(attrMask).separator = ",";
        rows = df_ri_combined.rows();
        float[] ri_col_phase32 = df_ri_combined.getColumnNumeric(attrRIIndx);
        MinMax ri_col_phase2 = (MinMax)df_ri_phase2.getColumnNumeric(attrRIIndx);
        MinMax min_max_22 = ArrayUtils.getMinMax(ri_col_phase32, false);
        MinMax min_max_422 = ArrayUtils.getMinMax((float[])ri_col_phase2, false);
        boolean min_max_422 = false;
        float ri_col_phase32 = min_max_422.minValue * 0.999f;
        float min_max_22 = min_max_22.minValue;
        float[] min_max_422 = ri_col_phase32;
        MinMax minMax = ArrayUtils.getMinMax(ri_col_phase32, false);
        int n = 0;
        while (n < min_max_422.length) {
            if (min_max_422[n] >= 0.0f) {
                min_max_422[n] = (min_max_422[n] - minMax.minValue) / (minMax.maxValue - minMax.minValue);
                min_max_422[n] = min_max_422[n] * (ri_col_phase32 - min_max_22) + min_max_22;
            }
            ++n;
        }
        int i2 = 0;
        while (i2 < rows) {
            String currAttr = df_ri_combined.get(i2, attrColIndex).toString();
            int currIdx_2 = df_ri_phase2.getRowIdx(currAttr);
            if (currIdx_2 < 0) {
                void ri_col_phase1_scaled;
                df_ri_combined.set(i2, attrRIIndx, Float.valueOf((float)ri_col_phase1_scaled[i2]));
            } else {
                df_ri_combined.set(i2, 0, df_ri_phase2.getRow(currIdx_2));
            }
            ++i2;
        }
        return df_ri_combined;
    }

    /*
     * WARNING - void declaration
     */
    private static void zipResult(MCFSParams mcfsParams) {
        String experimentName = mcfsParams.getExperimentName();
        String[] files = MCFSParams.getAllResultFileName(experimentName);
        try {
            void var1_1;
            MCFSParams mCFSParams;
            void var3_3;
            FileOutputStream fos = new FileOutputStream(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + ".zip");
            ZipOutputStream zos = new ZipOutputStream(fos);
            int i = 0;
            while (i < 15) {
                DiscFunctions.addFileToZip(String.valueOf(mcfsParams.resFilesPATH) + File.separator + files[i], zos);
                ++i;
            }
            DiscFunctions.addFileToZip(String.valueOf(mcfsParams.resFilesPATH) + File.separator + experimentName + ".run", zos);
            zos.close();
            var3_3.close();
            i = 0;
            while (i < 15) {
                DiscFunctions.deleteFile(String.valueOf(mcfsParams.resFilesPATH) + File.separator + files[i]);
                ++i;
            }
            DiscFunctions.deleteFile(String.valueOf(mCFSParams.resFilesPATH) + File.separator + (String)var1_1 + ".run");
            return;
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
            return;
        }
    }
}

