/*
 * Decompiled with CFR 0.152.
 */
package dmLab.gui.graphViewer.visualization;

import dmLab.array.functions.DiscFunctions;
import dmLab.mcfs.attributesID.graph.GraphEdge;
import dmLab.mcfs.attributesID.graph.GraphNode;
import dmLab.mcfs.attributesID.graph.IDGraph;
import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.tree.MutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;

public final class GraphVisualization {
    private static int MAX_SATURATION = 100;
    private static int MIN_SATURATION = 0;
    private static Color EDGE_COLOR = Color.DARK_GRAY;
    private static Color FONT_COLOR = Color.WHITE;
    private static float IMPORTANT_CELL_HUE = 0.0f;
    private static float OTHER_CELL_HUE = 0.0f;
    private static int MAX_EDGE_WIDTH = 5;
    private static int MIN_EDGE_WIDTH = 1;
    private static float CENTER_X = 400.0f;
    private static float CENTER_Y = 230.0f;
    private static float R = 200.0f;
    private JGraph graph;
    private float minImportanceValue;
    private static int edgeWeightFormat = 2;

    public GraphVisualization() {
        this.clean();
    }

    public final void clean() {
        this.minImportanceValue = -1.0f;
        this.graph = null;
    }

    public final JGraph getGraph() {
        return this.graph;
    }

    public final BufferedImage getImage() {
        return this.graph.getImage(Color.WHITE, 1);
    }

    /*
     * WARNING - void declaration
     */
    private void initGraphModel() {
        void var2_2;
        void var1_1;
        DefaultGraphModel model = new DefaultGraphModel();
        GraphLayoutCache view = new GraphLayoutCache((GraphModel)model, (CellViewFactory)new DefaultCellViewFactory());
        this.graph = new JGraph((GraphModel)var1_1, (GraphLayoutCache)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void createGraph(IDGraph connectionsGraph) {
        void var2_2;
        void var1_1;
        DefaultEdge defaultEdge;
        int nodesNumber = connectionsGraph.getNodesNumber();
        int edgesNumber = connectionsGraph.getEdgesNumber();
        this.initGraphModel();
        Object[] cells = new DefaultGraphCell[nodesNumber + edgesNumber];
        double angleStep = 360.0 / (double)nodesNumber;
        GraphNode[] nodes = connectionsGraph.getNodes();
        float maxNodeWeight = connectionsGraph.getMaxNodeWeight();
        float minNodeWeight = connectionsGraph.getMinNodeWeight();
        int i = 0;
        while (i < nodes.length) {
            void nodeColor;
            double angle = angleStep * (double)i;
            double a = Math.sin(angle * Math.PI / 180.0) * (double)R;
            double b = Math.sqrt(Math.pow(R, 2.0) - Math.pow(a, 2.0));
            double x = (double)CENTER_X + a;
            double y = 90.0 < angle && angle <= 270.0 ? (double)CENTER_Y + b : (double)CENTER_Y - b;
            DefaultGraphCell cell = new DefaultGraphCell((Object)nodes[i].name);
            GraphConstants.setBounds((Map)cell.getAttributes(), (Rectangle2D)new Rectangle2D.Double(x, y, 100.0, 20.0));
            float nodeSaturation = (nodes[i].weight - minNodeWeight) / (maxNodeWeight - minNodeWeight);
            nodeSaturation = (float)MAX_SATURATION * nodeSaturation + 0.0f;
            nodeSaturation /= (float)MAX_SATURATION;
            Color nodeColor2 = this.minImportanceValue != -1.0f && nodes[i].weight < this.minImportanceValue ? Color.getHSBColor(0.0f, 0.0f, 0.7f) : Color.getHSBColor(0.0f, (float)nodeColor, 0.8f);
            Color color = nodeColor2;
            defaultEdge = cell;
            GraphConstants.setBackground((Map)defaultEdge.getAttributes(), (Color)color);
            GraphConstants.setForeground((Map)defaultEdge.getAttributes(), (Color)FONT_COLOR);
            GraphConstants.setOpaque((Map)defaultEdge.getAttributes(), (boolean)true);
            GraphConstants.setAutoSize((Map)defaultEdge.getAttributes(), (boolean)true);
            nodeColor2 = new DefaultPort();
            defaultEdge.add((MutableTreeNode)((Object)nodeColor2));
            cells[i] = cell;
            ++i;
        }
        float maxEdgeWeight = connectionsGraph.getMaxEdgeWeight();
        float minEdgeWeight = connectionsGraph.getMinEdgeWeight();
        GraphEdge[] edges = var1_1.getEdges();
        void cellIndex = var2_2;
        int i2 = 0;
        while (i2 < edgesNumber) {
            DefaultEdge edge = new DefaultEdge((Object)DiscFunctions.formatFloat(edges[i2].weight, edgeWeightFormat));
            edge.setSource((Object)cells[edges[i2].nodeIndex1].getChildAt(0));
            edge.setTarget((Object)cells[edges[i2].nodeIndex2].getChildAt(0));
            float edgeWidth = (edges[i2].weight - minEdgeWeight) / (maxEdgeWeight - minEdgeWeight);
            float f = edgeWidth = (float)(MAX_EDGE_WIDTH - MIN_EDGE_WIDTH) * edgeWidth + (float)MIN_EDGE_WIDTH;
            defaultEdge = edge;
            GraphConstants.setLineEnd((Map)defaultEdge.getAttributes(), (int)2);
            GraphConstants.setLabelAlongEdge((Map)defaultEdge.getAttributes(), (boolean)true);
            GraphConstants.setEndFill((Map)defaultEdge.getAttributes(), (boolean)true);
            GraphConstants.setLineColor((Map)defaultEdge.getAttributes(), (Color)EDGE_COLOR);
            GraphConstants.setLineWidth((Map)defaultEdge.getAttributes(), (float)f);
            cells[cellIndex++] = edge;
            ++i2;
        }
        this.graph.getGraphLayoutCache().insert(cells);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean saveGraph(String fileName) {
        void var1_1;
        GraphVisualization graphVisualization;
        try {
            FileOutputStream out = new FileOutputStream(new File(fileName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found. File: ".concat(String.valueOf(fileName)));
            return false;
        }
        XMLEncoder enc = new XMLEncoder((OutputStream)((Object)graphVisualization));
        enc.setExceptionListener(new ExceptionListener(this){
            private /* synthetic */ GraphVisualization this$0;
            {
                this.this$0 = graphVisualization;
            }

            @Override
            public final void exceptionThrown(Exception e) {
            }
        });
        XMLEncoder xMLEncoder = enc;
        graphVisualization = this;
        try {
            xMLEncoder.setPersistenceDelegate(DefaultGraphModel.class, new DefaultPersistenceDelegate(new String[]{"roots", "attributes"}));
            xMLEncoder.setPersistenceDelegate(GraphLayoutCache.class, new DefaultPersistenceDelegate(new String[]{"model", "factory", "cellViews", "hiddenCellViews", "partial"}));
            xMLEncoder.setPersistenceDelegate(DefaultGraphCell.class, new DefaultPersistenceDelegate(new String[]{"userObject"}));
            xMLEncoder.setPersistenceDelegate(DefaultEdge.class, new DefaultPersistenceDelegate(new String[]{"userObject"}));
            xMLEncoder.setPersistenceDelegate(DefaultPort.class, new DefaultPersistenceDelegate(new String[]{"userObject"}));
            xMLEncoder.setPersistenceDelegate(AbstractCellView.class, new DefaultPersistenceDelegate(new String[]{"cell", "attributes"}));
            xMLEncoder.setPersistenceDelegate(DefaultEdge.DefaultRouting.class, new PersistenceDelegate(graphVisualization){
                private /* synthetic */ GraphVisualization this$0;
                {
                    this.this$0 = graphVisualization;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected final Expression instantiate(Object oldInstance, Encoder out) {
                    void var1_1;
                    return new Expression(var1_1, GraphConstants.class, "getROUTING_SIMPLE", null);
                }
            });
            xMLEncoder.setPersistenceDelegate(DefaultEdge.LoopRouting.class, new PersistenceDelegate(graphVisualization){
                private /* synthetic */ GraphVisualization this$0;
                {
                    this.this$0 = graphVisualization;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                protected final Expression instantiate(Object oldInstance, Encoder out) {
                    void var1_1;
                    return new Expression(var1_1, GraphConstants.class, "getROUTING_DEFAULT", null);
                }
            });
            xMLEncoder.setPersistenceDelegate(ArrayList.class, xMLEncoder.getPersistenceDelegate(List.class));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)graphVisualization.graph, exception.getMessage(), "Error", 0);
        }
        enc.writeObject(this.graph.getGraphLayoutCache());
        var1_1.close();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean loadGraph(String fileName) {
        void var1_1;
        void var2_2;
        try {
            FileInputStream in = new FileInputStream(new File(fileName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File not found. File: ".concat(String.valueOf(fileName)));
            return false;
        }
        XMLDecoder dec = new XMLDecoder((InputStream)var2_2);
        this.initGraphModel();
        this.graph.setGraphLayoutCache((GraphLayoutCache)dec.readObject());
        var1_1.close();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMinImportanceValue(float minImportanceValue) {
        void var1_1;
        this.minImportanceValue = var1_1;
    }
}

