% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_x-to-monad.R
\name{combine}
\alias{combine}
\title{Takes a list of monads and joins them}
\usage{
combine(ms, keep_history = TRUE, desc = NULL)
}
\arguments{
\item{ms}{A list of monads}

\item{keep_history}{Merge the histories of all monads}

\item{desc}{A description of the monad (usually the producing code)}
}
\description{
If any of the monads are failing, the resulting one will also
}
\details{
Any non-monadic values will be converted to monads. However, combine will
NOT catch errors. To safely build monadic lists, use lsmeval.
}
\examples{
z <- list(
  x = rnorm(10) \%>>\% sqrt,
  y = 1 \%>>\% colSums
)
combine(z)
}
