% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot.metareg_function.R
\name{forestplot_metareg}
\alias{forestplot_metareg}
\title{Comparator-specific forest-plot for network meta-regression}
\usage{
forestplot_metareg(full, reg, compar, cov_value, drug_names)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{reg}{An object of S3 class \code{\link{run_metareg}}. See 'Value' in
\code{\link{run_metareg}}.}

\item{compar}{A character to indicate the comparator intervention. It must
be any name found in \code{drug_names}.}

\item{cov_value}{A list of two elements in the following order: a number
for the covariate value of interest (see 'Arguments' in
\code{\link{run_metareg}}), and a character to indicate the name of
the covariate. See also 'Details'.}

\item{drug_names}{A vector of labels with the name of the interventions in
the order they appear in the argument \code{data} of
\code{\link{run_model}}. If \code{drug_names} is not defined,
the order of the interventions as they appear in \code{data} is used,
instead.}
}
\value{
A panel of two forest plots: (1) a forest plot on the estimated
  effect size of comparisons with the selected intervention of the network,
  and (2) a forest plot on the predicted effect size of comparisons with the
  selected intervention of the network. Both forest plots illustrate the
  results from network meta-analysis and network meta-regression using
  different colours for the corresponding lines.
}
\description{
This function illustrates a forest plot of the posterior mean
  and 95\% credible and predictive interval of comparisons with the selected
  intervention of the network under the network meta-analysis and network
  meta-regression.
}
\details{
In both plots, the y-axis displays all interventions in the
  network; the selected intervention that comprises the \code{compar} is
  indicated in the plot with a homonymous label. The numerical results are
  displayed above each line.
  Odds ratio and ratio of means are reported in the original scale after
  exponentiation of the logarithmic scale.

  When the covariate is binary, specify in the second element of
  \code{cov_value} the name of the level for which the forest plot will be
  created.

  In both plots, the interventions are sorted in the descending order of
  their SUCRA values based on the network meta-analysis.

  \code{forestplot} can be used only for a network of interventions. In the
  case of two interventions, the execution of the function will be stopped
  and an error message will be printed on the R console.
}
\references{
Salanti G, Ades AE, Ioannidis JP. Graphical methods and numerical summaries
for presenting results from multiple-treatment meta-analysis: an overview and
tutorial. \emph{J Clin Epidemiol} 2011;\bold{64}(2):163--71.
\doi{10.1016/j.jclinepi.2010.03.016}
}
\seealso{
\code{\link{run_metareg}}, \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
