% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.metareg_function.R
\name{run_metareg}
\alias{run_metareg}
\title{Perform Bayesian pairwise or network meta-regression}
\usage{
run_metareg(
  full,
  covariate,
  covar_assumption,
  n_chains,
  n_iter,
  n_burnin,
  n_thin
)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}.
See 'Value' in \code{\link{run_model}}.}

\item{covariate}{A numeric vector or matrix for a trial-specific covariate
that is a potential effect modifier. See 'Details'.}

\item{covar_assumption}{Character string indicating the structure of the
intervention-by-covariate interaction, as described in
Cooper et al. (2009). Set \code{covar_assumption} equal to
\code{"exchangeable"}, \code{"independent"}, or \code{"common"}.}

\item{n_chains}{Positive integer specifying the number of chains for the
MCMC sampling; an argument of the \code{\link[R2jags:jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 2.}

\item{n_iter}{Positive integer specifying the number of Markov chains for the
MCMC sampling; an argument of the \code{\link[R2jags:jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 10000.}

\item{n_burnin}{Positive integer specifying the number of iterations to
discard at the beginning of the MCMC sampling; an argument of the
\code{\link[R2jags:jags]{jags}} function of the R-package
\href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1000.}

\item{n_thin}{Positive integer specifying the thinning rate for the
MCMC sampling; an argument of the \code{\link[R2jags]{jags}} function
of the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1.}
}
\value{
A list of R2jags outputs on the summaries of the posterior
  distribution, and the Gelman-Rubin convergence diagnostic
  (Gelman et al., 1992) for the following monitored parameters for a
  fixed-effect pairwise meta-analysis:
  \item{EM}{The estimated summary effect measure (according to the argument
  \code{measure} defined in \code{\link{run_model}}).}
  \item{beta_all}{The estimated regression coefficient for all possible
  pairwise comparisons according to the argument \code{covar_assumption}.}
  \item{dev_o}{The deviance contribution of each trial-arm based on the
  observed outcome.}
  \item{hat_par}{The fitted outcome at each trial-arm.}
  \item{phi}{The informative missingness parameter.}

  For a fixed-effect network meta-analysis, the output additionally
  includes:
  \item{SUCRA}{The surface under the cumulative ranking (SUCRA) curve for
  each intervention.}
  \item{effectiveneness}{The ranking probability of each intervention for
  every rank.}

  For a random-effects pairwise meta-analysis, the output additionally
  includes the following elements:
  \item{EM_pred}{The predicted summary effect measure (according to the
  argument \code{measure} defined in \code{\link{run_model}}).}
  \item{delta}{The estimated trial-specific effect measure (according to the
  argument \code{measure} defined in \code{\link{run_model}}).
  For a multi-arm trial, we estimate \emph{T-1} effects, where \emph{T}
  is the number of interventions in the trial.}
  \item{tau}{The between-trial standard deviation.}

  In network meta-analysis, \code{EM} and \code{EM_pred} refer to all
  possible pairwise comparisons of interventions in the network. Furthermore,
  \code{tau} is typically assumed to be common for all observed comparisons
  in the network.
  For a multi-arm trial, we estimate a total \emph{T-1} of \code{delta} for
  comparisons with the baseline intervention of the trial (found in the first
  column of the element \bold{t}), with \emph{T} being the number of
  interventions in the trial.

  Furthermore, the output includes the following elements:
  \item{leverage_o}{The leverage for the observed outcome at each trial-arm.}
  \item{sign_dev_o}{The sign of the difference between observed and fitted
  outcome at each trial-arm.}
  \item{model_assessment}{A data-frame on the measures of model assessment:
  deviance information criterion, number of effective parameters, and total
  residual deviance.}
  \item{jagsfit}{An object of S3 class \code{\link[R2jags:jags]{jags}} with
  the posterior results on all monitored parameters to be used in the
  \code{\link{mcmc_diagnostics}} function.}

  The \code{run_metareg} function also returns the arguments \code{data},
  \code{measure}, \code{model}, \code{assumption}, \code{covariate},
  \code{covar_assumption}, \code{n_chains}, \code{n_iter}, \code{n_burnin},
  and \code{n_thin} to be inherited by other relevant functions of the
  package.
}
\description{
Performs a one-stage pairwise or network meta-regression while addressing
  aggregate binary or continuous missing participant outcome data via the
  pattern-mixture model.
}
\details{
\code{run_metareg} inherits the arguments \code{data},
  \code{measure}, \code{model}, \code{assumption}, \code{heter_prior},
  \code{mean_misspar}, \code{var_misspar}, \code{D}, \code{ref},
  \code{indic}, and \code{base_risk} from \code{\link{run_model}}
  (now contained in the argument \code{full}). This prevents specifying a
  different Bayesian model from that considered in \code{\link{run_model}}.
  Therefore, the user needs first to apply \code{\link{run_model}}, and then
  use \code{run_metareg} (see 'Examples').

  The model runs in \code{JAGS} and the progress of the simulation appears on
  the R console. The output of \code{run_metareg} is used as an S3 object by
  other functions of the package to be processed further and provide an
  end-user-ready output.

  The models described in Spineli et al. (2021), and Spineli (2019) have
  been extended to incorporate one \emph{study-level covariate} variable
  following the assumptions of Cooper et al. (2009) for the structure of the
  intervention-by-covariate interaction. The covariate can be either a
  numeric vector or matrix with columns equal to the maximum number of arms
  in the dataset.
}
\examples{
data("nma.baker2009")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_baker.rds', package = 'rnmamod'))

# Publication year
pub_year <- c(1996, 1998, 1999, 2000, 2000, 2001, rep(2002, 5), 2003, 2003,
              rep(2005, 4), 2006, 2006, 2007, 2007)

\donttest{
# Perform a random-effects network meta-regression (exchangeable structure)
# Note: Ideally, set 'n_iter' to 10000 and 'n_burnin' to 1000
run_metareg(full = res,
            covariate = pub_year,
            covar_assumption = "exchangeable",
            n_chains = 3,
            n_iter = 1000,
            n_burnin = 100,
            n_thin = 1)
}

}
\references{
Cooper NJ, Sutton AJ, Morris D, Ades AE, Welton NJ. Addressing between-study
heterogeneity and inconsistency in mixed treatment comparisons: Application
to stroke prevention treatments in individuals with non-rheumatic atrial
fibrillation. \emph{Stat Med} 2009;\bold{28}(14):1861--81.
doi: 10.1002/sim.3594

Gelman A, Rubin DB. Inference from iterative simulation using multiple
sequences. \emph{Stat Sci} 1992;\bold{7}(4):457--72.
doi: 10.1214/ss/1177011136

Spineli LM, Kalyvas C, Papadimitropoulou K. Continuous(ly) missing outcome
data in network meta-analysis: a one-stage pattern-mixture model approach.
\emph{Stat Methods Med Res} 2021;\bold{30}(4):958--75.
doi: 10.1177/0962280220983544

Spineli LM. An empirical comparison of Bayesian modelling strategies for
missing binary outcome data in network meta-analysis.
\emph{BMC Med Res Methodol} 2019;\bold{19}(1):86.
doi: 10.1186/s12874-019-0731-y
}
\seealso{
\code{\link[R2jags]{jags}}, \code{\link{run_model}}
}
\author{
{Loukia M. Spineli}
}
