% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.transitivity_function.R
\name{trans_quality}
\alias{trans_quality}
\title{Rating the quality of transitivity evaluation}
\usage{
trans_quality(
  plan_protocol,
  plan_methods,
  report_results,
  discuss_trans,
  proper_table
)
}
\arguments{
\item{plan_protocol}{Character string that indicates how the systematic
review planned in the protocol to assess the transitivity assumption. The
following values can be considered: \code{"Both"}, \code{"No"},
\code{"No protocol"}, \code{"Only direct methods"}, and
\code{"Only indirect methods"}. \code{"Both"} implies that at least one
direct and one indirect method has been used.}

\item{plan_methods}{Character string that indicates whether the systematic
review described in the methods section a strategy to assess the
transitivity assumption. The following values can be considered:
\code{"Yes"}, and \code{"No"}.}

\item{report_results}{Character string that indicates whether the systematic
review reported in the results section the transitivity evaluation and
which strategy was employed. The following values can be considered:
\code{"Both"}, \code{"No"}, \code{"Only direct methods"}, and
\code{"Only indirect methods"}. \code{"Both"} implies that at least one
direct and one indirect method has been used.}

\item{discuss_trans}{Character string that indicates whether the systematic
review discussed the transitivity assumption and which model parameters
where considered. The following values can be considered: \code{"Both"},
\code{"No"}, \code{"Only treatment effects"}, \code{"Other parameter"},
and \code{"NMA not conducted"}. \code{"Both"} implies that the treatment
effect and other model parameters were considered.}

\item{proper_table}{Character string that indicates whether the systematic
review reported a proper table of characteristics. The following values can
be considered: \code{"No"}, \code{"No table"}, and \code{"Yes"}.}
}
\value{
A character with value \code{"Low"}, \code{"Unclear"}, or
  \code{"High"} to indicate low, unclear, or high-quality of transitivity
  evaluation.
}
\description{
Classifies a systematic review with multiple interventions as
  having low, unclear or high quality regarding the transitivity evaluation.
}
\details{
A systematic review with \code{"Low"} quality of transitivity
  evaluation does not provide a protocol, nor describe the evaluation
  strategy in the methods section, does not report the evaluation results,
  nor discusses the transitivity evaluation and does not provide a table of
  characteristics. On the contrary, a systematic review with \code{"High"}
  quality of transitivity evaluation provides an evaluation plan in the
  protocol (including at least one direct method), describes the evaluation
  strategy in the methods section (including at least one direct method),
  reports the evaluation results in the results section, discusses the
  transitivity evaluation while considering at least one model parameter
  (if NMA has been conducted), and provides a proper table of
  characteristics. Otherwise, the systematic review is judged to have an
  \code{"Unclear"} quality of transitivity evaluation.
}
\references{
Spineli LM, Kalyvas C, Seide SE, Papadimitropoulou K. Low awareness of the
transitivity assumption in complex networks of interventions: empirical
evidence from 356 network meta-analyses. 2022 \emph{submitted}
}
\author{
{Loukia M. Spineli}
}
