% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rnoaa-package.r
\docType{package}
\name{rnoaa-package}
\alias{rnoaa}
\alias{rnoaa-package}
\title{General purpose R interface to NOAA datasets.}
\description{
rnoaa is an R interface to NOAA climate data.
}
\details{
Many functions in this package interact with the National Climatic Data Center application
programming interface (API) at http://www.ncdc.noaa.gov/cdo-web/webservices/v2, all of
which functions start with \code{ncdc_}. An access token, or API key, is required to use all
the \code{ncdc_} functions. The key is required by NOAA, not the creators of this R package.
Go to the link given above to get an API key.

More NOAA data sources are being added through time. Data sources and their function prefixes
are:

\itemize{
 \item \code{buoy_*} - NOAA Buoy data from the National Buoy Data Center
 \item \code{ghcnd_*} - GHCND daily data from NOAA
 \item \code{isd_*} - ISD/ISH data from NOAA
 \item \code{homr_*} - Historical Observing Metadata Repository (HOMR) vignette
 \item \code{ncdc_*} - NOAA National Climatic Data Center (NCDC) vignette (examples)
 \item \code{seaice} - Sea ice vignette
 \item \code{storm_} - Storms (IBTrACS) vignette
 \item \code{swdi} - Severe Weather Data Inventory (SWDI) vignette
 \item \code{tornadoes} - From the NOAA Storm Prediction Center
}
}
\section{A note about ncdf}{


Functions to work with buoy data use netcdf files. You'll need the \code{ncdf}
package for those functions, and those only. \code{ncdf} is in Suggests in
this package, meaning you only need \code{ncdf} if you are using the buoy
functions. You'll get an informative error telling you to install \code{ncdf}
if you don't have it and you try to use the buoy functions.

Installation of \code{ncdf} should be straightforward on Mac and Windows, but
on Linux you may have issues. See http://cran.r-project.org/web/packages/ncdf/INSTALL
}
\keyword{package}

