% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ersst.R
\name{ersst}
\alias{ersst}
\title{NOAA Extended Reconstructed Sea Surface Temperature (ERSST) data}
\usage{
ersst(year, month, path = "~/.rnoaa/ersst", overwrite = TRUE, ...)
}
\arguments{
\item{year}{(numeric) A year. Must be > 1853. The max value is whatever 
the current year is. Required}

\item{month}{A month, character or numeric. If single digit (e.g. 8), we
add a zero in front (e.g., 08). Required}

\item{path}{(character) A path to store the files, a directory. Default:
\code{~/.rnoaa/ersst}. Required.}

\item{overwrite}{(logical) To overwrite the path to store files in or not,
Default: \code{TRUE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}. Optional}
}
\value{
An \code{ncdf4} object for now, may change output later to
perhaps a data.frame. See \pkg{ncdf4} for parsing the output.
}
\description{
NOAA Extended Reconstructed Sea Surface Temperature (ERSST) data
}
\details{
NetCDF files are downloaded, stored, and read from the directory given in the 
\code{path} parameter. The default is \code{~/.rnoaa/ersst}, and files are 
saved within whatever that directory is.

Files are quite small, so we don't worry about reading in cached data to 
save time, as we do in other functions in this package.
}
\examples{
\dontrun{
# October, 2015
ersst(year = 2015, month = 10)

# May, 2015
ersst(year = 2015, month = 5)
ersst(year = 2015, month = "05")

# February, 1890
ersst(year = 1890, month = 2)

# Process data
library("ncdf4")
res <- ersst(year = 1890, month = 2)
## varibles
names(res$var)
## get a variable
ncdf4::ncvar_get(res, "lon_bnds")

# curl debugging
library('httr')
ersst(year = 2015, month = 10, config=verbose())
}
}
\references{
\url{https://www.ncdc.noaa.gov/data-access/marineocean-data/extended-reconstructed-sea-surface-temperature-ersst-v4}
}

