% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ghcnd.R
\name{ghcnd}
\alias{ghcnd}
\title{Get all GHCND data from a single weather site}
\usage{
ghcnd(stationid, path = "~/.rnoaa/ghcnd", ...)
}
\arguments{
\item{stationid}{A character string giving the identification of the weather
station for which the user would like to pull data. To get a full and
current list of stations, the user can use the \code{\link{ghcnd_stations}}
function. To identify stations within a certain radius of a location, the
user can use the \code{\link{meteo_nearby_stations}} function.}

\item{path}{A character vector giving the path to the directory to cache
the files locally. By default, the function uses \code{~/.rnoaa/isd}.}

\item{...}{Additional curl options to pass through to \code{\link[httr]{GET}}.}
}
\value{
A list object with a single slot, \code{data}, which contains the
   dataframe pulled from NOAA's FTP for the queried weather site. A README
   file with more information about the format of this file is available
   from NOAA (\url{http://www1.ncdc.noaa.gov/pub/data/ghcn/daily/readme.txt}).
   This file is formatted so each line of the file gives the daily weather
   observations for a single weather variable for all days of one month of
   one year. In addition to measurements, columns are included for certain
   flags, which add information on observation sources and quality and are
   further explained in NOAA's README file for the data.
}
\description{
This function uses ftp to access the Global Historical Climatology Network
daily weather data from NOAA's FTP server for a single weather site. It
requires the site identification number for that site and will pull the
entire weather dataset for the site.
}
\note{
This function saves the full set of weather data for the queried
site locally in the directory specified by the \code{path} argument.
}
\examples{
\dontrun{
# Get data
ghcnd(stationid = "AGE00147704")

stations <- ghcnd_stations()
ghcnd(stations$data$id[40])
ghcnd(stations$data$id[4000])
ghcnd(stations$data$id[10000])
ghcnd(stations$data$id[80000])
ghcnd(stations$data$id[80300])

library("dplyr")
ghcnd(stations$data$id[80300])$data \%>\% select(id, element) \%>\% slice(1:3)

# manipulate data
## using built in fxns
dat <- ghcnd(stationid="AGE00147704")
(alldat <- ghcnd_splitvars(dat))
library("ggplot2")
ggplot(subset(alldat$tmax, tmax >= 0), aes(date, tmax)) + geom_point()

## using dplyr
library("dplyr")
dat <- ghcnd(stationid="AGE00147704")
dat$data \%>\%
 filter(element == "PRCP", year == 1909)

}

}
\author{
Scott Chamberlain \email{myrmecocystus@gmail.com},
Adam Erickson \email{adam.erickson@ubc.ca}
}
\seealso{
To generate a weather dataset for a single weather site that has been
cleaned to a tidier weather format, the user should use the
\code{\link{ghcnd_search}} function, which calls \code{\link{ghcnd}} and then
processes the output, or \code{\link{meteo_tidy_ghcnd}}, which wraps the
\code{\link{ghcnd_search}} function to output a tidy dataframe rather than a
list object. To pull GHCND data from multiple monitors, see
\code{\link{meteo_pull_monitors}}.
}

