% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seasonalAverages.R
\name{seasonalAverages}
\alias{seasonalAverages}
\title{Calculate seasonal averages}
\usage{
seasonalAverages(timeseries, season = "Spring", startSeason = NULL,
  endSeason = NULL, parallel = FALSE)
}
\arguments{
\item{timeseries}{Time series (xts class).}

\item{season}{Name of the season (Autumn, Winter, Spring, Summer)}

\item{startSeason}{String encoding the start of the season (e.g. for spring in the northen hemisphere this is "03-21")}

\item{endSeason}{String encoding the end of the season (e.g. for spring in the northen emisphere this is "06-20")}

\item{parallel}{Logical, FALSE by default. If parallel = TRUE means that the function can be used in parallel computations.}
}
\value{
A vector containing the seasonal average and significance level (p-value) for each time series.
}
\description{
This calculates the seasonal averages from a time series.
}
\examples{
\dontrun{
  seasonalAverages(CMR(18019), season = "Spring")
  seasonalAverages(list(CMR(18019), CMR(18019)), season = "Spring")
}

}

