% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intTab.R
\name{intTab}
\alias{intTab}
\title{Interaction table}
\usage{
intTab(x, y, frequencies = c("relative", "absolute"))
}
\arguments{
\item{x}{an object of class table}

\item{y}{the corresponding independence table which is of class \dQuote{intTab}.}

\item{frequencies}{indicates whether absolute or relative frequencies should be computed.}
}
\value{
\itemize{
  \item{intTab}{The interaction table(s) with either relative or absolute frequencies.}
  \item{signs}{The sign illustrates if there is an excess of probability (plus), or a 
deficit (minus) regarding to the estimated probability table and the independece table in the clr space.}
}
}
\description{
Estimates the interaction table based on clr and inverse clr coefficients.
}
\details{
Because of the compositional nature of probability tables, the independence tables should 
be estimated using geometric marginals.
}
\examples{
data(precipitation)
tab1prob <- prop.table(precipitation)
tab1 <- indTab(precipitation)
intTab(tab1prob, tab1)
}
\references{
Egozcue, J.J., Pawlowsky-Glahn, V., Templ, M., Hron, K. (2015)
Independence in contingency tables using simplicial geometry. 
\emph{Communications in Statistics - Theory and Methods}, 44 (18), 3978--3996.
}
\author{
Matthias Templ
}
