% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_emp.R
\name{robustness_emp}
\alias{robustness_emp}
\title{Empirical Robustness of a Network}
\usage{
robustness_emp(
  A,
  ext_seq = "uniform",
  nb_iter = 300,
  net_type = "bipartite",
  method = "ordered",
  power = 1,
  block = NULL
)
}
\arguments{
\item{A}{A binary incident matrix}

\item{ext_seq}{A string, the rule for the primary extinctions sequences,
one of \code{"uniform"}, the default for uniform extinctions sequences,
\code{"decreasing"} and \code{"increasing"} for primary extinctions sequences
by increasing and decreasing degree order sequence on the row species}

\item{nb_iter}{An integer, the number of generated sequences. Default to
\code{300}.}

\item{net_type}{A string, the type of network. For now, only "bipartite" is
available.}

\item{method}{A string used when \code{ext_seq = "decreasing"} or
\code{ext_seq = "increasing"}:
\itemize{
\item \code{"linear"} (default) set an extinction
probability for each row species that is linear in its degree. It is a
shortcut for \code{method = "power"} and \code{power = 1}.
\item \code{"ordered"} strictly follow the degree order, i.e. the most
connected species will always goes last for \code{ext_seq = "increasing"}
or first for \code{ext_seq = "decreasing"}.
}}

\item{power}{An integer (default to 1). Only used when
\code{method = "power"},
the power to which the degree are elevated to compute the primary extinctions
sequences for \code{"increasing"} and \code{"decreasing"} ext_seq. For 1, it
is equivalent to \code{method = "linear"}, for 0, it is the same as
\code{ext_seq = "uniform"}. The largest the number the closest it will be to
\code{method = "ordered"}.}

\item{block}{A vector of row species memberships for \code{method = "block"}}
}
\value{
A list (robber object) with the following fields:
\itemize{
\item \code{$model}, \code{$ext_seq}, \code{$method}, \code{power}
\item \code{$fun} is the robustness function, a vector of size \code{(nrow(A) +1)}
\item \code{$sd} Standard deviation of the secondary extinctions
\item \code{$auc} the area under the curve of the robustness function
}
}
\description{
Compute the robustness of an ecological network by averaging
over a great number of randomly generated primary extinctions sequences
}
\examples{
A <- matrix(c(1, 0, 0,
             0, 1, 0,
             0, 0, 1,
             1, 1, 1), nrow = 4, ncol = 3, byrow = TRUE)
my_rob <- robustness_emp(A, ext_seq = "increasing")
my_rob$fun
my_rob$auc
}
