% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN_external_function.R
\name{robinCompare}
\alias{robinCompare}
\title{robinCompare}
\usage{
robinCompare(
  graph,
  method1 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "leiden", "other"),
  args1 = list(),
  method2 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "leiden", "other"),
  args2 = list(),
  FUN1 = NULL,
  FUN2 = NULL,
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  type = NULL,
  verbose = TRUE,
  dist = "Other",
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{method1}{The first clustering method, one of "walktrap", 
"edgeBetweenness", "fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","leiden","optimal","other".}

\item{args1}{A \code{list} of arguments to be passed to the \code{method1} 
(see i.e. \link[igraph]{cluster_leiden} for a list of possible method parameters).}

\item{method2}{The second custering method one of "walktrap",
"edgeBetweenness","fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","leiden","optimal","other".}

\item{args2}{A \code{list} of arguments to be passed to the \code{method2}
(see i.e. \link[igraph]{cluster_leiden} for a list of possible method parameters).}

\item{FUN1}{personal designed function when \code{method1} is "other". 
see \code{\link{methodCommunity}}.}

\item{FUN2}{personal designed function when \code{method2} is "other". 
see \code{\link{methodCommunity}}.}

\item{measure}{The stability measure, one of "vi", "nmi", "split.join", 
"adjusted.rand" all normalized and used as distances.
"nmi" refers to 1- nmi and "adjusted.ran" refers to 1-adjusted.rand.}

\item{type}{Character indicating "independent" or "dependent" for the old 
robin type contruction. If NULL the new faster version is computed 
(default NULL).}

\item{verbose}{flag for verbose output (default as TRUE).}

\item{dist}{Option to rewire in a manner that retains overall graph weight 
regardless of distribution of edge weights. This option is invoked by putting 
any text into this field. Defaults to "Other". See
  \code{\link[perturbR]{rewireR}} for details.}

\item{BPPARAM}{the BiocParallel object of class \code{bpparamClass} that 
specifies the back-end to be used for computations. See
  \code{\link[BiocParallel]{bpparam}} for details.}
}
\value{
A list object with two matrices:
- the matrix "Mean1" with the means of the procedure for the first method 
- the matrix "Mean2" with the means of the procedure for the second method
}
\description{
This function compares the robustness of two community 
detection algorithms.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
robinCompare(graph=graph, method1="louvain", args1 = list(resolution=0.8),
            method2="leiden", args2=list(objective_function ="modularity"))
}
