% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{initialize.project}
\alias{initialize.project}
\title{Intialize the Project Environment}
\usage{
initialize.project(datasets, origins, experiments, data.path,
  work.path = NULL, marker.genes = NULL, clear.history = F,
  analysis.label = NULL, convert.to.mouse.gene.symbols = NULL)
}
\arguments{
\item{datasets}{list of dataset code names}

\item{origins}{list of dataset tissue origin/condition full name}

\item{experiments}{list of experiment design annotations}

\item{data.path}{path to where the data is located}

\item{work.path}{path to where the analysis results are stored; optional, by
default, a temporary directory}

\item{marker.genes}{set of genes of interest for visualization purposes}

\item{clear.history}{whether you would like to remove any previous project by this name}

\item{analysis.label}{whether you would like to add a specific label to the analysis folder}

\item{convert.to.mouse.gene.symbols}{whether you are using human gene symbols and would like to convert them to mouse gene symbols}
}
\value{
\code{environment} parameter containing file paths and experiment parameters
}
\description{
Set up a project environment variable mapped to project results folder.
}
\examples{
data.path <- system.file("extdata", package = "robustSingleCell")
LCMV1_proj <- initialize.project(datasets = "LCMV1",
                            origins = "CD44+ cells",
                            experiments = "Rep1",
                            data.path = data.path,
                            work.path = tempdir())
}
