% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rocTree.R
\name{plotTreeHaz}
\alias{plotTreeHaz}
\title{Plotting the estimated hazard function from an rocTree object}
\usage{
plotTreeHaz(x, ghN = NULL)
}
\arguments{
\item{x}{an object of class "rocTree", usually returned by the rocTree function.}

\item{ghN}{an optional smoothing parameter used in smoothing hazard functions;
the default value is 0.2.}
}
\description{
Plot the estimated hazard function from rocTree objects.
}
\examples{
set.seed(1)
dat <- simu(100, 0, 1.3)
library(survival)
system.time(fit <- rocTree(Surv(Time, death) ~ z1 + z2, id = id,
data = dat, control = list(prune = TRUE, nflds = 10)))
plotTreeHaz(fit)
}
