% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{heatmap}
\alias{heatmap}
\title{Generic convenience function to create a heatmap}
\usage{
heatmap(
  data,
  x,
  y,
  fill,
  xLab = x,
  yLab = y,
  fillLab = fill,
  plotTitle = "Heatmap",
  fillScale = ggplot2::scale_fill_viridis_c(),
  theme = ggplot2::theme_minimal()
)
}
\arguments{
\item{data}{A data frame}

\item{x, y, fill}{The variables (columns) in \code{data} to use for the x axis,
y axis, and fill of the heatmap, respectively.}

\item{xLab, yLab, fillLab}{The labels to use for the x axis, y axis, and fill,
respectively}

\item{plotTitle}{The plot title.}

\item{fillScale}{The fill scale.}

\item{theme}{The theme.}
}
\value{
The heatmap, as a ggplot2 object.
}
\description{
Generic convenience function to create a heatmap
}
\examples{
rock::heatmap(mtcars, 'am', 'cyl', 'mpg');
}
