% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_utterances_and_codes_from_source.R
\name{get_utterances_and_codes_from_source}
\alias{get_utterances_and_codes_from_source}
\title{Get utterances and codes from source}
\usage{
get_utterances_and_codes_from_source(x, ...)
}
\arguments{
\item{x}{Either the result of a call to \code{\link[=parse_source]{parse_source()}}, or
a path or text to pass to \code{\link[=parse_source]{parse_source()}}.}

\item{...}{Arguments to \code{\link[=parse_source]{parse_source()}}, which is called to
parse the source.}
}
\value{
A list containing \verb{$utterances_raw}, \verb{$utterances_clean}, \verb{$uids$},
\verb{$codeMatches}, and \verb{$codesPerUtterance}.
}
\description{
This is a convenience function to use when displaying a source. It returns
an object with the raw and clean utterances in a source, as well as the
utterance identifiers and a list with vectors of the codes for each
utterance.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Parse single example source
res <-
  rock::get_utterances_and_codes_from_source(
    exampleFile
  );
}
