% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perspEmpty.R
\name{perspEmpty}
\alias{perspEmpty}
\title{perspEmpty}
\usage{
perspEmpty(x1, x2, y, x1lab = "x1", x2lab = "x2", ylab = "y", x1lim,
  x2lim, ...)
}
\arguments{
\item{x1}{data for the first horizontal axis, an R vector}

\item{x2}{data for the second horizontal axis, an R vector}

\item{y}{data for the vertical axis, an R vector}

\item{x1lab}{label for the x1 axis, (the one called "xlab" inside persp)}

\item{x2lab}{label for the x2 axis, (the one called "ylab" inside persp)}

\item{ylab}{label for the y (vertical) axis (the one called "zlab" inside persp)}

\item{x1lim}{Optional: limits for x1 axis (should be a vector with 2 elements)}

\item{x2lim}{Optional: limits for x2 axis (should be a vector with 2 elements)}

\item{...}{further arguments that are passed to persp. Please note
Please remember that y is the vertical axis, but for persp, that
is the one I call x2.  Thus dot-dot-dot arguments including xlab,
ylab, zlab, xlim, ylim, and zlim are going to be ignored.}
}
\value{
The perspective matrix that is returned by persp
}
\description{
Creates a persp plot without drawing anything in the interior.
Does equivalent \code{of plot( type="n")} for persp.
}
\details{
Regression demonstrations require a blank slate in which
points and planes can be drawn. This function creates that
blank persp canvas for those projects. It is not necessary
that x1, x2 and y be vectors of the same length, since this
function's only purpose is to plot an empty box with ranges
determined by the input variables. persp calls the 3 axes
x, y, and z, but here they are called x1, x2, and y.
}
\examples{
x1 <- 1:10
x2 <- 41:50
y <-  rnorm(10)
perspEmpty(x1, x2, y)
res <- perspEmpty(x1, x2, y, ticktype="detailed", nticks=10)
mypoints1 <- trans3d ( x1, x2, y, pmat = res )
points( mypoints1, pch = 16, col= "blue")
}
