% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{kurtosis}
\alias{kurtosis}
\title{Calculate excess kurtosis}
\usage{
kurtosis(x, na.rm = TRUE, excess = TRUE, unbiased = TRUE)
}
\arguments{
\item{x}{A numeric variable (vector)}

\item{na.rm}{default TRUE. Should missing data be removed?}

\item{excess}{default TRUE. If true, function returns excess kurtosis (kurtosis -3). If false, the return is simply kurtosis as defined above.}

\item{unbiased}{default TRUE. Should the denominator of the variance estimate be divided by N-1, rather than N?}
}
\value{
A scalar value or NA
}
\description{
Kurtosis is a summary of the peakedness of a distribution. In a Normal distribution,
the kurtosis is 3.  The term "excess kurtosis" refers to the difference
}
\details{
kurtosis - 3

Many researchers use the term kurtosis to refer to "excess
kurtosis" and this function follows suit by returning excess
kurtosis.  The user may avoid this by setting excess = FALSE, in
which case kurtosis is returned.

If na.rm = FALSE and there are missing values, the mean and
variance are undefined and this function returns NA.

The kurtosis may be calculated with the small-sample
bias-corrected estimate of the variance. Set unbiased = FALSE if
this is not desired.  It appears somewhat controversial whether
this is necessary, hence the argument unbiased. According to the
US NIST,
\url{http://www.itl.nist.gov/div898/handbook/eda/section3/eda35b.htm},
kurtosis is defined as
      
                mean((x - mean(x))^4)
kurtosis =    ___________________
                 var(x)^2

where var(x) is calculated with the denominator N, rather than N-1.

A distribution is said to be leptokurtotic if it is tightly bunched in the center (spiked) and there are long, narrow tails representing extreme values that might occur.
}
\author{
Paul Johnson <pauljohn@ku.edu>
}

