% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc_eval_functions.R
\name{roc_eval_text}
\alias{roc_eval_text}
\title{Generate Rd from text with evaluated inline code and code blocks}
\usage{
roc_eval_text(roclet, input)
}
\arguments{
\item{roclet}{Name of roclet to use for processing.}

\item{input}{Source string}
}
\value{
List with names as \code{fun_name.Rd}, where each element is the \code{\link[roxygen2]{RoxyTopic}} for
the corresponding function, same as the return of \code{\link[roxygen2]{roc_proc_text}}.
}
\description{
\code{roc_eval_text} is an upgraded version of \code{\link[roxygen2]{roc_proc_text}}
that evaluates inline and block code before generating Rd.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
# Formulate a text version of a function with documentation
fun_text <- '
#\' \\\\code{iris} is a `r nrow(iris)`-row matrix.
#\'
#\' \\\\code{iris} matrix has
#\' ```{r results="hold"}
#\' ncol(iris)
#\' ```
#\' columns.
print_iris <- function() iris
'

# Parse the 'roxygen' comments to Rd documentation
roc_eval_text(roxygen2::rd_roclet(), fun_text)[[1L]]
}
\author{
Xiurui Zhu
}
