% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table_transform.R
\name{select_instances_by_comparison}
\alias{select_instances_by_comparison}
\alias{select_instances_by_comparison.flat_table}
\title{Select instances of a flat table by comparison}
\usage{
select_instances_by_comparison(ft, not, attributes, comparisons, values)

\method{select_instances_by_comparison}{flat_table}(
  ft,
  not = FALSE,
  attributes = NULL,
  comparisons,
  values
)
}
\arguments{
\item{ft}{A \code{flat_table} object.}

\item{not}{A boolean.}

\item{attributes}{A list of name vectors.}

\item{comparisons}{A list of comparison operator vectors.}

\item{values}{A list of value vectors.}
}
\value{
A \code{flat_table} object.
}
\description{
Select only the indicated instances from the flat table by comparison.
}
\details{
The elements of the three parameter lists correspond (all three must have the
same structure and length or be of length 1). AND is performed for each
combination of attribute, operator and value within each element of each list
and OR between elements of the lists.

If the parameter \code{not} is true, the negation operation will be applied to the
result.
}
\examples{

ft <- flat_table('iris', iris) |>
  select_instances_by_comparison(attributes = 'Species',
                                 comparisons = '>=',
                                 values = 'v')

ft <- flat_table('ft_num', ft_num) |>
  select_instances_by_comparison(
    not = FALSE,
    attributes = c('Year', 'Year', 'WEEK'),
    comparisons = c('>=', '<=', '=='),
    values = c('1962', '1964', '2')
  )

ft <- flat_table('ft_num', ft_num) |>
  select_instances_by_comparison(
    not = FALSE,
    attributes = c('Year', 'Year', 'WEEK'),
    comparisons = c('>=', '<=', '=='),
    values = list(c('1962', '1964', '2'),
                  c('1962', '1964', '4'))
  )

}
\seealso{
\code{\link{flat_table}}

Other flat table transformation functions: 
\code{\link{add_custom_column}()},
\code{\link{remove_instances_without_measures}()},
\code{\link{replace_empty_values}()},
\code{\link{replace_string}()},
\code{\link{replace_unknown_values}()},
\code{\link{select_attributes}()},
\code{\link{select_instances}()},
\code{\link{select_measures}()},
\code{\link{separate_measures}()},
\code{\link{transform_attribute_format}()},
\code{\link{transform_from_values}()},
\code{\link{transform_to_attribute}()},
\code{\link{transform_to_measure}()},
\code{\link{transform_to_values}()}
}
\concept{flat table transformation functions}
