% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll.R
\name{roll_any}
\alias{roll_any}
\title{Rolling Any}
\usage{
roll_any(x, width, min_obs = width, complete_obs = FALSE,
  na_restore = FALSE, online = TRUE)
}
\arguments{
\item{x}{logical vector or matrix. Rows are observations and columns are variables.}

\item{width}{integer. Window size.}

\item{min_obs}{integer. Minimum number of observations required to have a value within a window,
otherwise result is \code{NA}.}

\item{complete_obs}{logical. If \code{TRUE} then rows containing any missing values are removed,
if \code{FALSE} then each value is used.}

\item{na_restore}{logical. Should missing values be restored?}

\item{online}{logical. Process observations using an online algorithm.}
}
\value{
An object of the same class and dimension as \code{x} with the rolling and expanding
any.
}
\description{
A function for computing the rolling and expanding any of time-series data.
}
\examples{
n <- 15
x <- rnorm(n)

# rolling any with complete windows
roll_any(x < 0, width = 5)

# rolling any with partial windows
roll_any(x < 0, width = 5)

# expanding any with partial windows
roll_any(x < 0, width = n)
}
