% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{makeOutput}
\alias{makeOutput}
\title{Combine the results of rollmatch into a tidy list for output
As it's an internal helper function to aid in testing, it is not exported for use outside of the package.}
\usage{
makeOutput(pred_model, lr_result, data_full, matches, orig.call, formula, tm,
  entry, lookback)
}
\arguments{
\item{pred_model}{The propensity scoring model create in runModel}

\item{lr_result}{The dataset given to runModel with the additional of the
score values generated by the propensity score model}

\item{data_full}{The original data provided with the additional of
control weights}

\item{matches}{Dataframe containing the matches from comparison_pool}

\item{orig.call}{The original call of the main function}

\item{formula}{Original formula used}

\item{tm}{The time period indicator.}

\item{entry}{The time period in which the participant enrolled in the
intervention (in the same units as the tm variable).}

\item{lookback}{The number of time periods to look back before the
time period of enrollment (1-10).}
}
\value{
\code{output} returns a list containing the following components:
\item{call}{The original \code{rollmatch} call.}
\item{model}{The output of the model used to estimate the distance measure.}
\item{scores}{The propensity score and logit of the propensity score. }
\item{data}{The original dataset with matches, scores, and weights applied.}
\item{summary}{A basic summary table.}
\item{ids_not_matched}{A vector of unmatched treatment ids}
\item{total_not_matched}{The count of unmatched treatment ids}
}
\description{
Combine the results of rollmatch into a tidy list for output
As it's an internal helper function to aid in testing, it is not exported for use outside of the package.
}
\examples{
\dontrun{ 
orig.call <- "Ignore"
formula <- as.formula(treat ~ qtr_pmt + yr_pmt + age + is_male + is_white +
                       is_disabled + is_esrd + months_dual + chron_num + lq_ed +
                       yr_ed2 + lq_ip + yr_ip2)
tm <- "quarter"; entry <- "entry_q"; lookback <- 1
load(url(paste0("https://github.com/RTIInternational/rollmatch/raw/master/",
                "tests/testthat/output.rda")))
pred_model <- output$pred_model
lr_result <- output$lr_result
load(url(paste0("https://github.com/RTIInternational/rollmatch/raw/master/",
                "tests/testthat/out_list.rda")))
data_full <- out_list$data_full
matches <- out_list$matches
out <- makeOutput(pred_model, lr_result, data_full, matches, orig.call,
                  formula, tm, entry, lookback)
head(out)
}

}
\keyword{internal}
