% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduce_data.R
\name{reduce_data}
\alias{reduce_data}
\title{Preprocessing Step to Rolling Entry Matching}
\usage{
reduce_data(data, treat, tm, entry, id, lookback = 1)
}
\arguments{
\item{data}{Original dataset before reduce_data() was ran.}

\item{treat}{String for name of treatment variable in data.}

\item{tm}{String for time period indicator variable name in data.}

\item{entry}{String for name of time period in which the participant
enrolled in the intervention (in the same units as the tm variable).}

\item{id}{String for individual id variable name in data.}

\item{lookback}{The number of time periods to look back before the
time period of enrollment (1-...).}
}
\value{
\code{reduced_data} returns a dataset of reduced data ready
for propensity scoring and to use in the function score_data()
}
\description{
Preprocessing Step to Rolling Entry Matching
}
\examples{
data(package="rollmatch", "rem_synthdata_small")
reduced_data <- reduce_data(data = rem_synthdata_small, treat = "treat",
                            tm = "quarter", entry = "entry_q",
                            id = "indiv_id", lookback = 1)
reduced_data

}
