% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim_reduction.R
\name{add_pcs}
\alias{add_pcs}
\title{Add PCA Loadings}
\usage{
add_pcs(
  tomic,
  value_var = NULL,
  center_rows = TRUE,
  npcs = NULL,
  missing_val_method = "drop_samples"
)
}
\arguments{
\item{tomic}{Either a \code{tidy_omic} or \code{triple_omic} object}

\item{value_var}{An abundance value to use with \code{hclust}}

\item{center_rows}{center rows before performing PCA}

\item{npcs}{number of principal component loadings to add to samples
(default is number of samples)}

\item{missing_val_method}{Approach to remove missing values:
\describe{
  \item{drop_features}{Drop features with missing values}
  \item{drop_samples}{Drop samples which are missing all features,
    then drop features}
  \item{impute}{Impute missing values}
}}
}
\value{
A \code{tomic} object with principal components added to samples.
}
\description{
Add Principal Components Analysis Loadings to a tidy or triple omics
  dataset.
}
\examples{
add_pcs(brauer_2008_triple, npcs = 5)

}
