% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/six_hourly_to_hourly.R
\name{six_hourly_to_hourly}
\alias{six_hourly_to_hourly}
\title{Convert 6 hour seasonal forecast to hourly time-step}
\usage{
six_hourly_to_hourly(df, latitude, longitude, use_solar_geom = TRUE)
}
\arguments{
\item{df}{data frame with 6-hour time step}

\item{latitude}{latitude degree north}

\item{longitude}{long longitude degree east}

\item{use_solar_geom}{use solar geometry to determine hourly solar radiation}
}
\value{
data frame with an hourly time step
}
\description{
Convert 6 hour seasonal forecast to hourly time-step
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_seasonal_forecast(
latitude = 37.30,
longitude = -79.83,
forecast_days = 30,
past_days = 5,
variables = glm_variables(product = "seasonal_forecast",
                         time_step = "6hourly")) |>
six_hourly_to_hourly(
    latitude = 37.30,
    longitude = -79.83,
    use_solar_geom = TRUE)
\dontshow{\}) # examplesIf}
}
