% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roper_download.R
\name{roper_download}
\alias{roper_download}
\title{Download datasets from the Roper Center}
\usage{
roper_download(file_id, email = getOption("roper_email"),
  password = getOption("roper_password"), reset = FALSE,
  download_dir = "roper_data", msg = TRUE, convert = TRUE)
}
\arguments{
\item{file_id}{The unique identifier (or optionally a vector of these identifiers)
for the dataset(s) to be downloaded (see details).}

\item{email, password}{Your Roper Center email and password (see details)}

\item{reset}{If TRUE, you will be asked to re-enter your Roper Center email and password.}

\item{download_dir}{The directory (relative to your working directory) to
which files from the Roper Center will be downloaded.}

\item{msg}{If TRUE, outputs a message showing which data set is being downloaded.}

\item{convert}{If TRUE, converts downloaded file(s) to .RData format.}
}
\value{
The function returns downloaded files.
}
\description{
\code{roper_download} provides a programmatic and reproducible means to download datasets 
  from the Roper Center's data archive
}
\details{
To avoid requiring others to edit your scripts to insert their own email and  
 password or to force them to do so interactively, the default is set to fetch 
 this information from the user's .Rprofile.  Before running \code{roper_download}, 
 then, you should be sure to add these options to your .Rprofile substituting your 
 info for the example below:

 \code{
  options("roper_email" = "juanita-herrara@uppermidwest.edu",
         "roper_password" = "password123!")
 }
}
\examples{
\dontrun{
 roper_download(file_id = c("CNCIPO1996-96010", "CNCIPO2000-02"))
}

}
