% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drawing.R
\name{drawUtilityPlots}
\alias{drawUtilityPlots}
\title{Draw marginal value functions and chart of alternative utilities}
\usage{
drawUtilityPlots(problem, solution, printLabels = TRUE, criteria = NULL,
  plotsPerRow = 2, descending = NULL)
}
\arguments{
\item{problem}{Problem.}

\item{solution}{Solution.}

\item{printLabels}{Whether to print labels.}

\item{criteria}{Vector containing  \emph{0} for utility chart and/or indices
of criteria for which marginal value functions should be plotted.
If this parameter was \code{NULL} functions for all criteria and utility chart
will be plotted (default \code{NULL}).}

\item{plotsPerRow}{Number of plots per row (default \code{2}).}

\item{descending}{Mode of sorting alternatives on utility chart:
\itemize{
\item \code{NULL} - unsorted, preserved \code{problem$perf} order,
\item \code{TRUE} - sorted descending by value of utility,
\item \code{FALSE} - sorted ascending by value of utility.
}}
}
\description{
This function draws marginal value functions and alternative utilities chart.
}
\details{
This function is deprecated. Use \code{\link{plotVF}} and \code{\link{plotComprehensiveValue}}.
}
\seealso{
\code{\link{plotVF}}
\code{\link{plotComprehensiveValue}}
}

