% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlays.R
\name{osm.segments}
\alias{osm.segments}
\title{Overlay segments on an OSM plot}
\usage{
osm.segments(x0, y0, x1 = x0, y1 = y0, epsg = 4326, toepsg = 3857, ...)
}
\arguments{
\item{x0}{X1 coordinate vector}

\item{y0}{Y1 coordinate vector}

\item{x1}{X2 coordinate vector}

\item{y1}{Y2 coordinate vector}

\item{epsg}{EPSG code of the supplied coordinates}

\item{toepsg}{EPSG code of the projected coordinates to be ploted}

\item{...}{Args passed on to \code{points}}
}
\description{
Plot segments on a plot created by \link{osm.plot}. This is a simple wrapper around
\code{segments()}.
}
\examples{
\dontshow{if (identical(Sys.getenv("R_PRETTYMAPR_HAS_API_KEY"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(rosm)
library(prettymapr)
locs <- geocode(c("wolfville, ns", "kentville, ns", "halifax, ns"))
prettymap({
  osm.plot(searchbbox("nova scotia"))
  osm.segments(locs$lon[1:2], locs$lat[1:2], locs$lon[2:3], locs$lat[2:3])
})
}
\dontshow{\}) # examplesIf}
}
