\name{Fisher}
\alias{Fisher}
\alias{dfisher}
\alias{pfisher}
\alias{rfisher}
\title{The matrix-Fisher distribution}
\usage{
  dfisher(r, kappa = 1, nu = NULL, Haar = TRUE)

  pfisher(q, kappa = 1, nu = NULL, lower.tail = TRUE)

  rfisher(n, kappa = 1, nu = NULL)
}
\arguments{
  \item{r,q}{vector of quantiles.}

  \item{n}{number of observations.  If \code{length(n)>1},
  the length is taken to be the number required.}

  \item{kappa}{concentration parameter.}

  \item{nu}{circular variance, can be used in place of
  \code{kappa}.}

  \item{Haar}{logical; if TRUE density is evaluated with
  respect to the Haar measure.}

  \item{lower.tail}{logical; if TRUE (default),
  probabilities are \eqn{P(X \le x)} otherwise, \eqn{P(X >
  x)}.}
}
\value{
  \item{dfisher}{gives the density} \item{pfisher}{gives
  the distribution function} \item{rfisher}{generates
  random deviates}
}
\description{
  Density, distribution function and random generation for
  the matrix-Fisher distribution with concentration
  \code{kappa} \eqn{\kappa}.
}
\details{
  The matrix-Fisher distribution with concentration
  \eqn{\kappa} has density
  \deqn{C_\mathrm{{F}}(r|\kappa)=\frac{1}{2\pi[\mathrm{I_0}(2\kappa)-\mathrm{I_1}(2\kappa)]}e^{2\kappa\cos(r)}[1-\cos(r)]}{C(r|\kappa)=exp[2\kappa
  cos(r)][1-cos(r)]/(2\pi[I0(2\kappa)-I1(2\kappa)])} with
  respect to Lebesgue measure where
  \eqn{\mathrm{I}_p(\cdot)}{Ip()} denotes the Bessel
  function of order \eqn{p} defined as
  \eqn{\mathrm{I}_p(\kappa)=\frac{1}{2\pi}\int_{-\pi}^{\pi}\cos(pr)e^{\kappa\cos
  r}dr}{Ip(\kappa)}.
}
\examples{
r <- seq(-pi, pi, length = 500)

#Visualize the matrix Fisher density fucntion with respect to the Haar measure
plot(r, dfisher(r, kappa = 10), type = "l", ylab = "f(r)")

#Visualize the matrix Fisher density fucntion with respect to the Lebesgue measure
plot(r, dfisher(r, kappa = 10, Haar = FALSE), type = "l", ylab = "f(r)")

#Plot the matrix Fisher CDF
plot(r,pfisher(r,kappa = 10), type = "l", ylab = "F(r)")

#Generate random observations from matrix Fisher distribution
rs <- rfisher(20, kappa = 1)
hist(rs, breaks = 10)
}
\seealso{
  \link{Angular-distributions} for other distributions in
  the rotations package.
}

