% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_data.R
\name{taxon_external_IDs}
\alias{taxon_external_IDs}
\title{Get external identifiers for data associated with an Open Tree taxon}
\usage{
taxon_external_IDs(taxon_id)
}
\arguments{
\item{taxon_id}{An open tree study ID}
}
\value{
a data.frame in which each row represents a unique record in an
external database. The column "source" provides and abbreviated name for the
database, and "id" the unique ID for the record.
}
\description{
The Open Tree taxonomy is a synthesis of multiple reference taxonomies. This
function retrieves identifiers to external taxonomic records that have
contributed the rank, position and definition of a given Open Tree taxon.
}
\examples{
\dontrun{
   gibbon_IDs <- taxon_external_IDs(712902)
}
}
\seealso{
tnrs_matchnames, which can be used to search for taxa by name.

taxonomy_taxon, for more information about a given taxon.
}
