% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BackupQueue.R
\name{BackupQueueDate}
\alias{BackupQueueDate}
\title{An R6 class for managing datestamped backups}
\description{
A BackupQueue for date-stamped backups, e.g. \code{foo.log}, \verb{foo.2020-07-24.log}
}
\details{
This class is part of the \link[R6:R6Class]{R6} API of \strong{rotor} which is
intended for developers that want to extend this package. For normal usage,
the simpler functional API is recommended (see \code{\link[=rotate]{rotate()}}).
}
\seealso{
Other R6 Classes: 
\code{\link{BackupQueueDateTime}},
\code{\link{BackupQueueIndex}},
\code{\link{BackupQueue}},
\code{\link{Cache}},
\code{\link{DirectoryQueue}}
}
\concept{R6 Classes}
\section{Super classes}{
\code{\link[rotor:DirectoryQueue]{rotor::DirectoryQueue}} -> \code{\link[rotor:BackupQueue]{rotor::BackupQueue}} -> \code{\link[rotor:BackupQueueDateTime]{rotor::BackupQueueDateTime}} -> \code{BackupQueueDate}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{BackupQueueDate$new()}}
\item \href{#method-set_fmt}{\code{BackupQueueDate$set_fmt()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="DirectoryQueue" data-id="set_dir">}\href{../../rotor/html/DirectoryQueue.html#method-set_dir}{\code{rotor::DirectoryQueue$set_dir()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueue" data-id="print">}\href{../../rotor/html/BackupQueue.html#method-print}{\code{rotor::BackupQueue$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueue" data-id="prune_identical">}\href{../../rotor/html/BackupQueue.html#method-prune_identical}{\code{rotor::BackupQueue$prune_identical()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueue" data-id="push_backup">}\href{../../rotor/html/BackupQueue.html#method-push_backup}{\code{rotor::BackupQueue$push_backup()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueue" data-id="set_backup_dir">}\href{../../rotor/html/BackupQueue.html#method-set_backup_dir}{\code{rotor::BackupQueue$set_backup_dir()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueue" data-id="set_compression">}\href{../../rotor/html/BackupQueue.html#method-set_compression}{\code{rotor::BackupQueue$set_compression()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueue" data-id="set_file">}\href{../../rotor/html/BackupQueue.html#method-set_file}{\code{rotor::BackupQueue$set_file()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueue" data-id="set_origin">}\href{../../rotor/html/BackupQueue.html#method-set_origin}{\code{rotor::BackupQueue$set_origin()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueueDateTime" data-id="prune">}\href{../../rotor/html/BackupQueueDateTime.html#method-prune}{\code{rotor::BackupQueueDateTime$prune()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueueDateTime" data-id="push">}\href{../../rotor/html/BackupQueueDateTime.html#method-push}{\code{rotor::BackupQueueDateTime$push()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueueDateTime" data-id="set_cache_backups">}\href{../../rotor/html/BackupQueueDateTime.html#method-set_cache_backups}{\code{rotor::BackupQueueDateTime$set_cache_backups()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueueDateTime" data-id="set_max_backups">}\href{../../rotor/html/BackupQueueDateTime.html#method-set_max_backups}{\code{rotor::BackupQueueDateTime$set_max_backups()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueueDateTime" data-id="should_rotate">}\href{../../rotor/html/BackupQueueDateTime.html#method-should_rotate}{\code{rotor::BackupQueueDateTime$should_rotate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rotor" data-topic="BackupQueueDateTime" data-id="update_backups_cache">}\href{../../rotor/html/BackupQueueDateTime.html#method-update_backups_cache}{\code{rotor::BackupQueueDateTime$update_backups_cache()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackupQueueDate$new(
  origin,
  dir = dirname(origin),
  max_backups = Inf,
  compression = FALSE,
  fmt = "\%Y-\%m-\%d",
  cache_backups = FALSE,
  backup_dir = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_fmt"></a>}}
\if{latex}{\out{\hypertarget{method-set_fmt}{}}}
\subsection{Method \code{set_fmt()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BackupQueueDate$set_fmt(x)}\if{html}{\out{</div>}}
}

}
}
