% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_simulation_performance_score.R
\name{getPerformanceScore}
\alias{getPerformanceScore}
\title{Get Performance Score}
\usage{
getPerformanceScore(simulationResult)
}
\arguments{
\item{simulationResult}{A simulation result.}
}
\description{
Calculates the conditional performance score, its sub-scores and components according to
(Herrmann et al. (2020), \doi{10.1002/sim.8534}) and
(Bokelmann et al. (2024), \doi{10.1186/s12874-024-02150-4}) for a given
simulation result from a two-stage design with continuous or binary endpoint.
Larger (sub-)score and component values refer to a better performance.
}
\details{
The conditional performance score consists of two sub-scores, one for the sample size
(subscoreSampleSize) and one for the conditional power (subscoreConditionalPower).
Each of those are composed of a location (locationSampleSize, locationConditionalPower)
and variation component (variationSampleSize, variationConditionalPower).
The term conditional refers to an evaluation perspective where the interim results
suggest a trial continuation with a second stage.
The score can take values between 0 and 1. More details on the performance score
can be found in Herrmann et al. (2020), \doi{10.1002/sim.8534} and
Bokelmann et al. (2024) \doi{10.1186/s12874-024-02150-4}.
}
\examples{
\dontrun{
# Example from Table 3 in "A new conditional performance score for 
# the evaluation of adaptive group sequential designs with samplesize 
# recalculation from Herrmann et al 2023", p. 2097 for 
# Observed Conditional Power approach and Delta = 0.5

# Create two-stage Pocock design with binding futility boundary at 0
design <- getDesignGroupSequential(
    kMax = 2, typeOfDesign = "P", 
    futilityBounds = 0, bindingFutility = TRUE)

# Initialize sample sizes and effect; 
# Sample sizes are referring to overall stage-wise sample sizes
n1 <- 100
n2 <- 100
nMax <- n1 + n2
alternative <- 0.5

# Perform Simulation; nMax * 1.5 defines the maximum 
# sample size for the additional stage
simulationResult <- getSimulationMeans(
    design = design,
    normalApproximation = TRUE,
    thetaH0 = 0,
    alternative = alternative,
    plannedSubjects = c(n1, nMax),
    minNumberOfSubjectsPerStage = c(NA_real_, 1),
    maxNumberOfSubjectsPerStage = c(NA_real_, nMax * 1.5),
    conditionalPower = 0.8,
    directionUpper = TRUE,
    maxNumberOfIterations = 1e05,
    seed = 140
)

# Calculate performance score
getPerformanceScore(simulationResult)
}

}
\author{
Stephen Schueuerhuis
}
