% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trees.R
\name{rename.tree}
\alias{rename.tree}
\title{Tree Node Renaming}
\usage{
rename.tree(tree, old.names, new.names)
}
\arguments{
\item{tree}{A vector of character strings, each containing a newick tree}

\item{old.names}{A vector of current names to be substituted}

\item{new.names}{A vector of equal length to old.names giving the
substitutions}
}
\value{
A vector of character strings, in which all nodes with names
given in old.names are replaced with values from new.names
}
\description{
Rename nodes of trees
}
\examples{
trees <- c("((hg18:1.0, panTro2:2.0):3.0, mm9:4.0);",
           "((hg18:0.142679,(mm9:0.083220,rn4:0.090564):0.269385):
                0.020666,canFam2:0.193569);")
rename.tree(trees,
            old.names=c("hg18", "panTro2", "mm9", "rn4", "canFam2"),
            new.names=c("human", "chimp", "mouse", "rat", "dog"))
}
\author{
Melissa J. Hubisz and Adam Siepel
}
\keyword{trees}

