% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_plum.R
\name{calib.plumbacon.plot}
\alias{calib.plumbacon.plot}
\title{Plot the dates}
\usage{
calib.plumbacon.plot(
  set = get("info"),
  BCAD = set$BCAD,
  cc = set$cc,
  firstPlot = FALSE,
  rotate.axes = FALSE,
  rev.d = FALSE,
  rev.age = FALSE,
  rev.yr = rev.age,
  age.lim = c(),
  yr.lim = age.lim,
  date.res = 100,
  d.lab = c(),
  age.lab = c(),
  yr.lab = age.lab,
  height = 15,
  calheight = 1,
  mirror = TRUE,
  up = TRUE,
  cutoff = 0.001,
  C14.col = rgb(0, 0, 1, 0.5),
  C14.border = rgb(0, 0, 1, 0.75),
  cal.col = rgb(0, 0.5, 0.5, 0.5),
  cal.border = rgb(0, 0.5, 0.5, 0.75),
  dates.col = c(),
  slump.col = grey(0.8),
  new.plot = TRUE,
  plot.dists = TRUE,
  same.heights = FALSE,
  normalise.dists = TRUE
)
}
\arguments{
\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{BCAD}{The calendar scale of graphs is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{cc}{Calibration curve to be used (defaults to info$cc)}

\item{firstPlot}{description}

\item{rotate.axes}{The default of plotting age on the horizontal axis and event probability on the vertical one can be changed with \code{rotate.axes=TRUE}.}

\item{rev.d}{The direction of the depth axis can be reversed from the default (\code{rev.d=TRUE}).}

\item{rev.age}{The direction of the calendar age axis can be reversed from the default (\code{rev.age=TRUE})}

\item{rev.yr}{Deprecated - use rev.age instead}

\item{age.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{age.lim=c()}).}

\item{yr.lim}{Deprecated - use age.lim instead}

\item{date.res}{Date distributions are plotted using \code{date.res=100} points by default.}

\item{d.lab}{The labels for the depth axis. Default \code{d.lab="Depth (cm)"}.}

\item{age.lab}{The labels for the calendar axis (default \code{yr.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{yr.lab}{Deprecated - use age.lab instead}

\item{height}{The heights of the distributions of the dates. See also \code{normalise.dists}.}

\item{calheight}{Multiplier for the heights of the distributions of dates on the calendar scale. Defaults to \code{calheight=1}.}

\item{mirror}{Plot the dates as 'blobs'. Set to \code{mirror=FALSE} to plot simple distributions.}

\item{up}{Directions of distributions if they are plotted non-mirrored. Default \code{up=TRUE}.}

\item{cutoff}{Avoid plotting very low probabilities of date distributions (default \code{cutoff=0.001}).}

\item{C14.col}{Colour of the calibrated distributions of the dates. Default is semi-transparent blue: \code{rgb(0,0,1,.35)}.}

\item{C14.border}{Colours of the borders of calibrated 14C dates. Default is transparent dark blue: cal.col}

\item{cal.col}{Colour of the non-14C dates in the age-depth plot: default semi-transparent blue-green: \code{rgb(0,.5,.5,.35)}.}

\item{cal.border}{Colour of the of the border of non-14C dates in the age-depth plot: default semi-transparent dark blue-green: \code{rgb(0,.5,.5,.5)}.}

\item{dates.col}{As an alternative to colouring dates based on whether they are 14C or not, sets of dates can be coloured as, e.g., \code{dates.col=colours()[2:100]}.}

\item{slump.col}{Colour of slumps. Defaults to \code{slump.col=grey(0.8)}.}

\item{new.plot}{Start a new plot (\code{new.plot=TRUE}) or plot over an existing plot (\code{new.plot=FALSE}).}

\item{plot.dists}{Plot the distributions of the dates (default \code{plot.dists=TRUE}).}

\item{same.heights}{Plot the distributions of the dates all at the same maximum height (default \code{same.height=FALSE}).}

\item{normalise.dists}{By default, the distributions of more precise dates will cover less time and will thus peak higher than less precise dates. This can be avoided by specifying \code{normalise.dists=FALSE}.}
}
\value{
NA
}
\description{
Produce a plot of the dated depths and their dates
}
\details{
This function is generally called internally to produce the age-depth graph.
It can be used to produce custom-built graphs.
}
\examples{
  Plum(run=FALSE, coredir=tempfile())
  calib.plot()

}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474.
\url{https://projecteuclid.org/euclid.ba/1339616472}
}
\seealso{
\url{http://www.qub.ac.uk/chrono/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
