% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgGetRast.R
\name{pgGetRast}
\alias{pgGetRast}
\title{Load raster from PostGIS database into R.}
\usage{
pgGetRast(
  conn,
  name,
  rast = "rast",
  bands = 1,
  boundary = NULL,
  clauses = NULL,
  returnclass = "terra",
  progress = TRUE
)
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database}

\item{name}{A character string specifying a PostgreSQL schema and
table/view name holding the geometry (e.g., \code{name =
c("schema","table")})}

\item{rast}{Name of the column in \code{name} holding the raster object. 
Defaults to "rast".}

\item{bands}{Index number(s) for the band(s) to retrieve (defaults to 1).
The special case (\code{bands = TRUE}) returns all bands in the raster. See
also 'Details'}

\item{boundary}{\code{sf} object, \code{SpatVector} object, or numeric. If a
spatial object is provided, its bounding box will be used to select
the part of the raster to import. Alternatively, a numeric vector
(\code{c([top], [bottom], [right], [left])}) indicating the 
projection-specific limits with which to clip the raster. If not value 
is provided, the default \code{boundary = NULL} will return the 
full raster.}

\item{clauses}{character, optional SQL to append to modify select
query from table. Must begin with 'WHERE'.}

\item{returnclass}{'terra' by default; or 'raster' for \code{raster} objects.}

\item{progress}{whether to show a progress bar (TRUE by default). The progress
bar mark the progress of reading bands from the database.}
}
\value{
\code{SpatRaster}; \code{raster}; or \code{RasterStack} object
}
\description{
Retrieve rasters from a PostGIS table into a \code{terra SpatRaster} object
}
\details{
Since version 1.5.0, this function retrieve SpatRaster objects from 
\code{terra} package by default. The argument \code{returnclass} can be 
used to return \code{raster} objects instead.

The argument \code{bands} can take as argument:

* The index of the desirable band (e.g. bands = 2 will fetch the second band
of the raster).

* More than one index for several bands (e.g. bands = c(2,4) will return a
\code{SpatRaster} with two bands).

* All bands in the raster (bands = TRUE).
}
\examples{
\dontrun{
pgGetRast(conn, c("schema", "tablename"))
pgGetRast(conn, c("schema", "DEM"), boundary = c(55,
    50, 17, 12))
}
}
\author{
David Bucklin \email{david.bucklin@gmail.com} and Adrián Cidre
González \email{adrian.cidre@gmail.com}
}
