% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.R
\name{mean_incidence_rate}
\alias{mean_incidence_rate}
\title{Mean disease incidence.}
\usage{
mean_incidence_rate(raw_inc, population_size, precision = 2, level = 0.95)
}
\arguments{
\item{raw_inc}{Vector of incidence values by year, as returned by
\code{\link{raw_incidence}}.}

\item{population_size}{Integer corresponding to the size of the population at
risk.}

\item{precision}{The number of decimal places required.}

\item{level}{The desired confidence interval width.}
}
\value{
A list with the following values:

  \item{absolute}{Overall incidence for the period of interest as a single
  double} \item{per100K}{Incidence for the period of interest per one hundred
  thousand} \item{per100K.lower}{Lower bounds of the specified confidence
  level on the per one hundred thousand estimate} \item{per100K.upper}{Upper
  bounds of the specified confidence level on the per one hundred thousand
  estimate}
}
\description{
Calculates the average incidence rate per one hundred thousand with
confidence intervals for the given registry data.
}
\examples{
data(prevsim)

rawinc <- raw_incidence(prevsim$entrydate)
mean_incidence_rate(rawinc, population_size=3.5e6)

rawinc2 <- raw_incidence(prevsim$entrydate, start="2005-05-01", num_reg_years=5)
mean_incidence_rate(rawinc2, population_size=3.5e6)

}
\seealso{
Other incidence functions: \code{\link{incidence_age_distribution}},
  \code{\link{incidence}}, \code{\link{plot.incidence}},
  \code{\link{raw_incidence}},
  \code{\link{test_incidence_fit}}
}

