% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{determine_yearly_endpoints}
\alias{determine_yearly_endpoints}
\title{Determine annual event delimiters.}
\usage{
determine_yearly_endpoints(date, num_years, direction = "forwards")
}
\arguments{
\item{date}{Either the starting date of the time interval (when \code{direction} is 'forwards')
or the ending date (\code{direction} is 'backwards').}

\item{num_years}{The number of years of the time interval.}

\item{direction}{A string indicating whether the parameter \code{date} represents
the opening or closing interval. Must take values either 'forwards' or 'backwards'.}
}
\value{
A vector of dates delineating complete years of registry data.
}
\description{
A helper function to calculate dates a year apart, starting from a given date
for a set number of years. Useful for delimiting a specified time
interval into a discrete number of years.
}
