% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop_non_sql.R
\name{ex_data_table.relop_non_sql}
\alias{ex_data_table.relop_non_sql}
\title{Direct non-sql (function) node, not implemented for \code{data.table} case.}
\usage{
\method{ex_data_table}{relop_non_sql}(
  optree,
  ...,
  tables = list(),
  source_usage = NULL,
  source_limit = NULL,
  env = parent.frame()
)
}
\arguments{
\item{optree}{relop operations tree.}

\item{...}{not used, force later arguments to bind by name.}

\item{tables}{named list map from table names used in nodes to data.tables and data.frames.}

\item{source_usage}{list mapping source table names to vectors of columns used.}

\item{source_limit}{if not null limit all table sources to no more than this many rows (used for debugging).}

\item{env}{environment to work in.}
}
\description{
Passes a single table to a function that takes a single data.frame as its argument, and returns a single data.frame.
}
\examples{

set.seed(3252)
d <- data.frame(a = rnorm(1000), b = rnorm(1000))

optree <- local_td(d) \%.>\%
  quantile_node(.)
ex_data_table(optree)

p2 <- local_td(d) \%.>\%
  rsummary_node(.)
ex_data_table(p2)

summary(d)

}
\seealso{
\code{\link{rq_df_funciton_node}}, \code{\link{rq_df_grouped_funciton_node}}
}
