% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clip.R
\name{rray_clip}
\alias{rray_clip}
\title{Bound the values of an array}
\usage{
rray_clip(x, low, high)
}
\arguments{
\item{x}{A vector, matrix, array or rray.}

\item{low}{A single value. The lower bound. \code{low} is cast to the
inner type of \code{x}.}

\item{high}{A single value. The upper bound. \code{high} is cast to the
inner type of \code{x}.}
}
\value{
\code{x} bounded by \code{low} and \code{high}.
}
\description{
\code{rray_clip()} sets \emph{inclusive} lower and upper bounds on the values of \code{x}.
}
\examples{

# bound `x` between 1 and 5
x <- matrix(1:10, ncol = 2)
rray_clip(x, 1, 5)

}
