% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{do3Rotate}
\alias{do3Rotate}
\alias{do3Rotate.tucker3}
\title{Varimax Rotation for Tucker3 models}
\usage{
do3Rotate(x, ...)

\method{do3Rotate}{tucker3}(x, weights = c(0, 0, 0), rotate = c("A",
  "B", "C"), ...)
}
\arguments{
\item{x}{A Tucker 3 object}

\item{\dots}{Potential further arguments passed to called functions.}

\item{weights}{A numeric vector with length 3: relative weights (greater or equal 0)
for the simplicity of the compoent matrices \code{A}, \code{B} and \code{C} respectively.}

\item{rotate}{Within which mode to rotate the Tucker3 solution:
\code{rotate="A"} means to rotate the component matrix \code{A} of mode A;
\code{rotate=c("A", "B")} means to rotate the component matrices \code{A} and
\code{B} of modes A and B respectively. Default is to rotate all modes,
i.e. \code{rotate=c("A", "B", "C")}.}
}
\value{
A list including the following components:
}
\description{
Computes \emph{varimax} rotation of the core and component matrix of a Tucker3 model to simple structure.
}
\author{
Valentin Todorov, \email{valentin.todorov@chello.at}
}
