/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.lang.UpdateParser;
import com.hp.hpl.jena.sparql.modify.UpdateSink;
import com.hp.hpl.jena.sparql.modify.UsingList;
import com.hp.hpl.jena.sparql.modify.UsingUpdateSink;
import com.hp.hpl.jena.update.GraphStore;
import com.hp.hpl.jena.update.GraphStoreFactory;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateException;
import com.hp.hpl.jena.update.UpdateExecutionFactory;
import com.hp.hpl.jena.update.UpdateFactory;
import com.hp.hpl.jena.update.UpdateProcessor;
import com.hp.hpl.jena.update.UpdateProcessorStreaming;
import com.hp.hpl.jena.update.UpdateRequest;
import java.io.InputStream;
import org.apache.jena.atlas.io.IO;

public class UpdateAction {
    public static void readExecute(String filename, Model model) {
        UpdateAction.readExecute(filename, GraphStoreFactory.create(model));
    }

    public static void readExecute(String filename, Dataset dataset) {
        UpdateAction.readExecute(filename, GraphStoreFactory.create(dataset));
    }

    public static void readExecute(String filename, DatasetGraph dataset) {
        UpdateAction.readExecute(filename, GraphStoreFactory.create(dataset));
    }

    public static void readExecute(String filename, Graph graph) {
        UpdateAction.readExecute(filename, GraphStoreFactory.create(graph));
    }

    public static void readExecute(String filename, GraphStore graphStore) {
        UpdateRequest req = UpdateFactory.read(filename);
        UpdateAction.execute(req, graphStore);
    }

    public static void parseExecute(String updateString, Model model) {
        UpdateAction.parseExecute(updateString, GraphStoreFactory.create(model));
    }

    public static void parseExecute(String updateString, Dataset dataset) {
        UpdateAction.parseExecute(updateString, GraphStoreFactory.create(dataset));
    }

    public static void parseExecute(String updateString, DatasetGraph dataset) {
        UpdateAction.parseExecute(updateString, GraphStoreFactory.create(dataset));
    }

    public static void parseExecute(String updateString, Graph graph) {
        UpdateAction.parseExecute(updateString, GraphStoreFactory.create(graph));
    }

    public static void parseExecute(String updateString, GraphStore graphStore) {
        UpdateRequest req = UpdateFactory.create(updateString);
        UpdateAction.execute(req, graphStore);
    }

    public static void execute(UpdateRequest request, Model model) {
        UpdateAction.execute(request, GraphStoreFactory.create(model));
    }

    public static void execute(UpdateRequest request, Dataset dataset) {
        UpdateAction.execute(request, GraphStoreFactory.create(dataset));
    }

    public static void execute(UpdateRequest request, DatasetGraph dataset) {
        UpdateAction.execute(request, GraphStoreFactory.create(dataset));
    }

    public static void execute(UpdateRequest request, Graph graph) {
        UpdateAction.execute(request, GraphStoreFactory.create(graph));
    }

    public static void execute(UpdateRequest request, GraphStore graphStore) {
        UpdateAction.execute$(request, graphStore);
    }

    private static void execute$(UpdateRequest request, GraphStore graphStore) {
        UpdateProcessor uProc = UpdateExecutionFactory.create(request, graphStore);
        if (uProc == null) {
            throw new ARQException("No suitable update procesors are registered/able to execute your updates");
        }
        uProc.execute();
    }

    public static void execute(Update update2, Model model) {
        UpdateAction.execute(update2, GraphStoreFactory.create(model));
    }

    public static void execute(Update update2, Dataset dataset) {
        UpdateAction.execute(update2, GraphStoreFactory.create(dataset));
    }

    public static void execute(Update update2, DatasetGraph dataset) {
        UpdateAction.execute(update2, GraphStoreFactory.create(dataset));
    }

    public static void execute(Update update2, Graph graph) {
        UpdateAction.execute(update2, GraphStoreFactory.create(graph));
    }

    public static void execute(Update update2, GraphStore graphStore) {
        UpdateAction.execute$(update2, graphStore);
    }

    private static void execute$(Update update2, GraphStore graphStore) {
        UpdateRequest request = new UpdateRequest();
        request.add(update2);
        UpdateAction.execute$(request, graphStore);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, String fileName) {
        UpdateAction.parseExecute(usingList, dataset, fileName, null, Syntax.defaultUpdateSyntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, String fileName, Syntax syntax) {
        UpdateAction.parseExecute(usingList, dataset, fileName, null, syntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, String fileName, String baseURI, Syntax syntax) {
        InputStream in = null;
        if (fileName.equals("-")) {
            in = System.in;
        } else {
            in = IO.openFile(fileName);
            if (in == null) {
                throw new UpdateException("File could not be opened: " + fileName);
            }
        }
        UpdateAction.parseExecute(usingList, dataset, in, baseURI, syntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input) {
        UpdateAction.parseExecute(usingList, dataset, input, Syntax.defaultUpdateSyntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input, Syntax syntax) {
        UpdateAction.parseExecute(usingList, dataset, input, null, syntax);
    }

    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input, String baseURI) {
        UpdateAction.parseExecute(usingList, dataset, input, baseURI, Syntax.defaultUpdateSyntax);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseExecute(UsingList usingList, DatasetGraph dataset, InputStream input, String baseURI, Syntax syntax) {
        GraphStore graphStore = GraphStoreFactory.create(dataset);
        UpdateProcessorStreaming uProc = UpdateExecutionFactory.createStreaming(graphStore);
        if (uProc == null) {
            throw new ARQException("No suitable update procesors are registered/able to execute your updates");
        }
        uProc.startRequest();
        try {
            UsingUpdateSink sink = new UsingUpdateSink(uProc.getUpdateSink(), usingList);
            try {
                UpdateParser parser = UpdateFactory.setupParser(sink.getPrologue(), baseURI, syntax);
                parser.parse((UpdateSink)sink, input);
            }
            finally {
                sink.close();
            }
        }
        finally {
            uProc.finishRequest();
        }
    }
}

