% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rl_synonyms.R
\name{rl_synonyms}
\alias{rl_synonyms}
\alias{rl_synonyms_}
\title{Get species narrative information by taxon name or IUCN id}
\usage{
rl_synonyms(name = NULL, key = NULL, parse = TRUE, ...)

rl_synonyms_(name = NULL, key = NULL, ...)
}
\arguments{
\item{name}{(character) Binomial taxonomic name}

\item{key}{A IUCN API token}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[httr]{GET}}}
}
\value{
A list, with the data in the \code{result} slot, unless using
a function with a trailing underscore, in which case json as character
string is returned.
}
\description{
Get species narrative information by taxon name or IUCN id
}
\examples{
\dontrun{
rl_synonyms('Loxodonta africana')
rl_synonyms('Loxodonta africana', parse = FALSE)
rl_synonyms_('Loxodonta africana')
}
}
\references{
API docs at \url{http://apiv3.iucnredlist.org/api/v3/docs}
}

